/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.utils;

import com.github.scribejava.core.utils.OAuthEncoder;
import org.junit.Assert;
import org.junit.Test;

public class OAuthEncoderTest {
    @Test
    public void shouldPercentEncodeString() {
        String plain = "this is a test &^";
        String encoded = "this%20is%20a%20test%20%26%5E";
        Assert.assertEquals((Object)"this%20is%20a%20test%20%26%5E", (Object)OAuthEncoder.encode((String)"this is a test &^"));
    }

    @Test
    public void shouldFormURLDecodeString() {
        String encoded = "this+is+a+test+%26%5E";
        String plain = "this is a test &^";
        Assert.assertEquals((Object)"this is a test &^", (Object)OAuthEncoder.decode((String)"this+is+a+test+%26%5E"));
    }

    @Test
    public void shouldPercentEncodeAllSpecialCharacters() {
        String plain = "!*'();:@&=+$,/?#[]";
        String encoded = "%21%2A%27%28%29%3B%3A%40%26%3D%2B%24%2C%2F%3F%23%5B%5D";
        Assert.assertEquals((Object)"%21%2A%27%28%29%3B%3A%40%26%3D%2B%24%2C%2F%3F%23%5B%5D", (Object)OAuthEncoder.encode((String)"!*'();:@&=+$,/?#[]"));
        Assert.assertEquals((Object)"!*'();:@&=+$,/?#[]", (Object)OAuthEncoder.decode((String)"%21%2A%27%28%29%3B%3A%40%26%3D%2B%24%2C%2F%3F%23%5B%5D"));
    }

    @Test
    public void shouldNotPercentEncodeReservedCharacters() {
        String plain = "abcde123456-._~";
        String encoded = "abcde123456-._~";
        Assert.assertEquals((Object)"abcde123456-._~", (Object)OAuthEncoder.encode((String)"abcde123456-._~"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionIfStringToEncodeIsNull() {
        OAuthEncoder.encode(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionIfStringToDecodeIsNull() {
        OAuthEncoder.decode(null);
    }

    @Test
    public void shouldPercentEncodeCorrectlyTwitterCodingExamples() {
        String[] sources = new String[]{"Ladies + Gentlemen", "An encoded string!", "Dogs, Cats & Mice"};
        String[] encoded = new String[]{"Ladies%20%2B%20Gentlemen", "An%20encoded%20string%21", "Dogs%2C%20Cats%20%26%20Mice"};
        for (int i = 0; i < sources.length; ++i) {
            Assert.assertEquals((Object)encoded[i], (Object)OAuthEncoder.encode((String)sources[i]));
        }
    }
}

