/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.extractors;

import com.github.scribejava.core.ObjectMother;
import com.github.scribejava.core.exceptions.OAuthParametersMissingException;
import com.github.scribejava.core.extractors.BaseStringExtractorImpl;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Verb;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;

public class BaseStringExtractorTest {
    private BaseStringExtractorImpl extractor;
    private OAuthRequest request;
    private OAuthRequest requestPort80;
    private OAuthRequest requestPort80v2;
    private OAuthRequest requestPort8080;
    private OAuthRequest requestPort443;
    private OAuthRequest requestPort443v2;

    @Before
    public void setUp() {
        this.request = ObjectMother.createSampleOAuthRequest();
        this.requestPort80 = ObjectMother.createSampleOAuthRequestPort80();
        this.requestPort80v2 = ObjectMother.createSampleOAuthRequestPort80v2();
        this.requestPort8080 = ObjectMother.createSampleOAuthRequestPort8080();
        this.requestPort443 = ObjectMother.createSampleOAuthRequestPort443();
        this.requestPort443v2 = ObjectMother.createSampleOAuthRequestPort443v2();
        this.extractor = new BaseStringExtractorImpl();
    }

    @Test
    public void shouldExtractBaseStringFromOAuthRequest() {
        String expected = "GET&http%3A%2F%2Fexample.com&oauth_callback%3Dhttp%253A%252F%252Fexample%252Fcallback%26oauth_consumer_key%3DAS%2523%2524%255E%252A%2540%2526%26oauth_signature%3DOAuth-Signature%26oauth_timestamp%3D123456";
        String baseString = this.extractor.extract(this.request);
        Assert.assertEquals((Object)"GET&http%3A%2F%2Fexample.com&oauth_callback%3Dhttp%253A%252F%252Fexample%252Fcallback%26oauth_consumer_key%3DAS%2523%2524%255E%252A%2540%2526%26oauth_signature%3DOAuth-Signature%26oauth_timestamp%3D123456", (Object)baseString);
    }

    @Test
    public void shouldExcludePort80() {
        String expected = "GET&http%3A%2F%2Fexample.com&oauth_callback%3Dhttp%253A%252F%252Fexample%252Fcallback%26oauth_consumer_key%3DAS%2523%2524%255E%252A%2540%2526%26oauth_signature%3DOAuth-Signature%26oauth_timestamp%3D123456";
        String baseString = this.extractor.extract(this.requestPort80);
        Assert.assertEquals((Object)"GET&http%3A%2F%2Fexample.com&oauth_callback%3Dhttp%253A%252F%252Fexample%252Fcallback%26oauth_consumer_key%3DAS%2523%2524%255E%252A%2540%2526%26oauth_signature%3DOAuth-Signature%26oauth_timestamp%3D123456", (Object)baseString);
    }

    @Test
    public void shouldExcludePort80v2() {
        String expected = "GET&http%3A%2F%2Fexample.com%2Ftest&oauth_callback%3Dhttp%253A%252F%252Fexample%252Fcallback%26oauth_consumer_key%3DAS%2523%2524%255E%252A%2540%2526%26oauth_signature%3DOAuth-Signature%26oauth_timestamp%3D123456";
        String baseString = this.extractor.extract(this.requestPort80v2);
        Assert.assertEquals((Object)"GET&http%3A%2F%2Fexample.com%2Ftest&oauth_callback%3Dhttp%253A%252F%252Fexample%252Fcallback%26oauth_consumer_key%3DAS%2523%2524%255E%252A%2540%2526%26oauth_signature%3DOAuth-Signature%26oauth_timestamp%3D123456", (Object)baseString);
    }

    @Test
    public void shouldIncludePort8080() {
        String expected = "GET&http%3A%2F%2Fexample.com%3A8080&oauth_callback%3Dhttp%253A%252F%252Fexample%252Fcallback%26oauth_consumer_key%3DAS%2523%2524%255E%252A%2540%2526%26oauth_signature%3DOAuth-Signature%26oauth_timestamp%3D123456";
        String baseString = this.extractor.extract(this.requestPort8080);
        Assert.assertEquals((Object)"GET&http%3A%2F%2Fexample.com%3A8080&oauth_callback%3Dhttp%253A%252F%252Fexample%252Fcallback%26oauth_consumer_key%3DAS%2523%2524%255E%252A%2540%2526%26oauth_signature%3DOAuth-Signature%26oauth_timestamp%3D123456", (Object)baseString);
    }

    @Test
    public void shouldExcludePort443() {
        String expected = "GET&https%3A%2F%2Fexample.com&oauth_callback%3Dhttp%253A%252F%252Fexample%252Fcallback%26oauth_consumer_key%3DAS%2523%2524%255E%252A%2540%2526%26oauth_signature%3DOAuth-Signature%26oauth_timestamp%3D123456";
        String baseString = this.extractor.extract(this.requestPort443);
        Assert.assertEquals((Object)"GET&https%3A%2F%2Fexample.com&oauth_callback%3Dhttp%253A%252F%252Fexample%252Fcallback%26oauth_consumer_key%3DAS%2523%2524%255E%252A%2540%2526%26oauth_signature%3DOAuth-Signature%26oauth_timestamp%3D123456", (Object)baseString);
    }

    @Test
    public void shouldExcludePort443v2() {
        String expected = "GET&https%3A%2F%2Fexample.com%2Ftest&oauth_callback%3Dhttp%253A%252F%252Fexample%252Fcallback%26oauth_consumer_key%3DAS%2523%2524%255E%252A%2540%2526%26oauth_signature%3DOAuth-Signature%26oauth_timestamp%3D123456";
        String baseString = this.extractor.extract(this.requestPort443v2);
        Assert.assertEquals((Object)"GET&https%3A%2F%2Fexample.com%2Ftest&oauth_callback%3Dhttp%253A%252F%252Fexample%252Fcallback%26oauth_consumer_key%3DAS%2523%2524%255E%252A%2540%2526%26oauth_signature%3DOAuth-Signature%26oauth_timestamp%3D123456", (Object)baseString);
    }

    public void shouldThrowExceptionIfRquestIsNull() {
        Assert.assertThrows(IllegalArgumentException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                BaseStringExtractorTest.this.extractor.extract(null);
            }
        });
    }

    public void shouldThrowExceptionIfRquestHasNoOAuthParameters() {
        final OAuthRequest request = new OAuthRequest(Verb.GET, "http://example.com");
        Assert.assertThrows(OAuthParametersMissingException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                BaseStringExtractorTest.this.extractor.extract(request);
            }
        });
    }

    @Test
    public void shouldProperlyEncodeSpaces() {
        String expected = "GET&http%3A%2F%2Fexample.com&body%3Dthis%2520param%2520has%2520whitespace%26oauth_callback%3Dhttp%253A%252F%252Fexample%252Fcallback%26oauth_consumer_key%3DAS%2523%2524%255E%252A%2540%2526%26oauth_signature%3DOAuth-Signature%26oauth_timestamp%3D123456";
        this.request.addBodyParameter("body", "this param has whitespace");
        Assert.assertEquals((Object)"GET&http%3A%2F%2Fexample.com&body%3Dthis%2520param%2520has%2520whitespace%26oauth_callback%3Dhttp%253A%252F%252Fexample%252Fcallback%26oauth_consumer_key%3DAS%2523%2524%255E%252A%2540%2526%26oauth_signature%3DOAuth-Signature%26oauth_timestamp%3D123456", (Object)this.extractor.extract(this.request));
    }
}

