/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.httpclient.ning;

import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthRequestAsync;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.httpclient.ning.NingHttpClientConfig;
import com.github.scribejava.httpclient.ning.OAuthAsyncCompletionHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import java.io.File;
import java.util.Map;
import java.util.concurrent.Future;

public class NingHttpClient
implements HttpClient {
    private final AsyncHttpClient client;

    public NingHttpClient(NingHttpClientConfig ningConfig) {
        String ningAsyncHttpProviderClassName = ningConfig.getNingAsyncHttpProviderClassName();
        AsyncHttpClientConfig config = ningConfig.getConfig();
        if (ningAsyncHttpProviderClassName == null) {
            this.client = config == null ? new AsyncHttpClient() : new AsyncHttpClient(config);
        } else {
            if (config == null) {
                config = new AsyncHttpClientConfig.Builder().build();
            }
            this.client = new AsyncHttpClient(ningAsyncHttpProviderClassName, config);
        }
    }

    public NingHttpClient(AsyncHttpClient client) {
        this.client = client;
    }

    public void close() {
        this.client.close();
    }

    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, byte[] bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequestAsync.ResponseConverter<T> converter) {
        return this.doExecuteAsync(userAgent, headers, httpVerb, completeUrl, BodySetter.BYTE_ARRAY, bodyContents, callback, converter);
    }

    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, String bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequestAsync.ResponseConverter<T> converter) {
        return this.doExecuteAsync(userAgent, headers, httpVerb, completeUrl, BodySetter.STRING, bodyContents, callback, converter);
    }

    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, File bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequestAsync.ResponseConverter<T> converter) {
        return this.doExecuteAsync(userAgent, headers, httpVerb, completeUrl, BodySetter.FILE, bodyContents, callback, converter);
    }

    private <T> Future<T> doExecuteAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, BodySetter bodySetter, Object bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequestAsync.ResponseConverter<T> converter) {
        AsyncHttpClient.BoundRequestBuilder boundRequestBuilder;
        switch (httpVerb) {
            case GET: {
                boundRequestBuilder = this.client.prepareGet(completeUrl);
                break;
            }
            case POST: {
                boundRequestBuilder = this.client.preparePost(completeUrl);
                break;
            }
            case PUT: {
                boundRequestBuilder = this.client.preparePut(completeUrl);
                break;
            }
            case DELETE: {
                boundRequestBuilder = this.client.prepareDelete(completeUrl);
                break;
            }
            default: {
                throw new IllegalArgumentException("message build error: unknown verb type");
            }
        }
        if (httpVerb == Verb.POST || httpVerb == Verb.PUT || httpVerb == Verb.DELETE) {
            if (!headers.containsKey("Content-Type")) {
                boundRequestBuilder = boundRequestBuilder.addHeader("Content-Type", "application/x-www-form-urlencoded");
            }
            boundRequestBuilder = bodySetter.setBody(boundRequestBuilder, bodyContents);
        }
        for (Map.Entry<String, String> header : headers.entrySet()) {
            boundRequestBuilder.addHeader(header.getKey(), header.getValue());
        }
        if (userAgent != null) {
            boundRequestBuilder.setHeader("User-Agent", userAgent);
        }
        return boundRequestBuilder.execute(new OAuthAsyncCompletionHandler<T>(callback, converter));
    }

    private static enum BodySetter {
        BYTE_ARRAY{

            @Override
            AsyncHttpClient.BoundRequestBuilder setBody(AsyncHttpClient.BoundRequestBuilder requestBuilder, Object bodyContents) {
                return requestBuilder.setBody((byte[])bodyContents);
            }
        }
        ,
        STRING{

            @Override
            AsyncHttpClient.BoundRequestBuilder setBody(AsyncHttpClient.BoundRequestBuilder requestBuilder, Object bodyContents) {
                return requestBuilder.setBody((String)bodyContents);
            }
        }
        ,
        FILE{

            @Override
            AsyncHttpClient.BoundRequestBuilder setBody(AsyncHttpClient.BoundRequestBuilder requestBuilder, Object bodyContents) {
                return (AsyncHttpClient.BoundRequestBuilder)requestBuilder.setBody((File)bodyContents);
            }
        };


        abstract AsyncHttpClient.BoundRequestBuilder setBody(AsyncHttpClient.BoundRequestBuilder var1, Object var2);
    }
}

