/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.httpclient.ning;

import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.ning.http.client.AsyncCompletionHandler;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OAuthAsyncCompletionHandler<T>
extends AsyncCompletionHandler<T> {
    private final OAuthAsyncRequestCallback<T> callback;
    private final OAuthRequest.ResponseConverter<T> converter;

    public OAuthAsyncCompletionHandler(OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        this.callback = callback;
        this.converter = converter;
    }

    public T onCompleted(com.ning.http.client.Response ningResponse) {
        try {
            Response t;
            HashMap headersMap = new HashMap();
            for (Map.Entry header : ningResponse.getHeaders().entrySet()) {
                StringBuilder value = new StringBuilder();
                for (String str : (List)header.getValue()) {
                    value.append(str);
                }
                headersMap.put(header.getKey(), value.toString());
            }
            Response response = new Response(ningResponse.getStatusCode(), ningResponse.getStatusText(), headersMap, ningResponse.getResponseBodyAsStream(), new Closeable[0]);
            Object object = t = this.converter == null ? response : this.converter.convert(response);
            if (this.callback != null) {
                this.callback.onCompleted((Object)t);
            }
            return (T)t;
        }
        catch (IOException | RuntimeException e) {
            this.onThrowable(e);
            return null;
        }
    }

    public void onThrowable(Throwable t) {
        if (this.callback != null) {
            this.callback.onThrowable(t);
        }
    }
}

