/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevtech.cloud.storage.spring.bean;

import com.amazonaws.services.s3.model.CannedAccessControlList;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import lombok.NonNull;

public class UploadFileRequest {
    @NonNull
    private InputStream stream;
    @NonNull
    private String folder;
    @NonNull
    private String name;
    @NonNull
    private String contentType;
    private String bucketName;
    private CannedAccessControlList accessControl = CannedAccessControlList.Private;

    @ConstructorProperties(value={"stream", "folder", "name", "contentType", "bucketName", "accessControl"})
    UploadFileRequest(@NonNull InputStream stream, @NonNull String folder, @NonNull String name, @NonNull String contentType, String bucketName, CannedAccessControlList accessControl) {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (folder == null) {
            throw new NullPointerException("folder");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (contentType == null) {
            throw new NullPointerException("contentType");
        }
        this.stream = stream;
        this.folder = folder;
        this.name = name;
        this.contentType = contentType;
        this.bucketName = bucketName;
        this.accessControl = accessControl;
    }

    public static UploadFileRequestBuilder builder() {
        return new UploadFileRequestBuilder();
    }

    @NonNull
    public InputStream getStream() {
        return this.stream;
    }

    @NonNull
    public String getFolder() {
        return this.folder;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getContentType() {
        return this.contentType;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public CannedAccessControlList getAccessControl() {
        return this.accessControl;
    }

    public static class UploadFileRequestBuilder {
        private InputStream stream;
        private String folder;
        private String name;
        private String contentType;
        private String bucketName;
        private CannedAccessControlList accessControl;

        UploadFileRequestBuilder() {
        }

        public UploadFileRequestBuilder stream(InputStream stream) {
            this.stream = stream;
            return this;
        }

        public UploadFileRequestBuilder folder(String folder) {
            this.folder = folder;
            return this;
        }

        public UploadFileRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public UploadFileRequestBuilder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public UploadFileRequestBuilder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public UploadFileRequestBuilder accessControl(CannedAccessControlList accessControl) {
            this.accessControl = accessControl;
            return this;
        }

        public UploadFileRequest build() {
            return new UploadFileRequest(this.stream, this.folder, this.name, this.contentType, this.bucketName, this.accessControl);
        }

        public String toString() {
            return "UploadFileRequest.UploadFileRequestBuilder(stream=" + this.stream + ", folder=" + this.folder + ", name=" + this.name + ", contentType=" + this.contentType + ", bucketName=" + this.bucketName + ", accessControl=" + this.accessControl + ")";
        }
    }
}

