/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevtech.cloud.storage.spring.bean;

import com.amazonaws.services.s3.model.CannedAccessControlList;
import java.io.InputStream;
import lombok.NonNull;

public class UploadFileRequest {
    @NonNull
    private InputStream stream;
    @NonNull
    private String folder;
    @NonNull
    private String name;
    @NonNull
    private String contentType;
    private String bucketName;
    private CannedAccessControlList accessControl;

    private static CannedAccessControlList $default$accessControl() {
        return CannedAccessControlList.Private;
    }

    UploadFileRequest(@NonNull InputStream stream, @NonNull String folder, @NonNull String name, @NonNull String contentType, String bucketName, CannedAccessControlList accessControl) {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        if (folder == null) {
            throw new NullPointerException("folder is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (contentType == null) {
            throw new NullPointerException("contentType is marked non-null but is null");
        }
        this.stream = stream;
        this.folder = folder;
        this.name = name;
        this.contentType = contentType;
        this.bucketName = bucketName;
        this.accessControl = accessControl;
    }

    public static UploadFileRequestBuilder builder() {
        return new UploadFileRequestBuilder();
    }

    @NonNull
    public InputStream getStream() {
        return this.stream;
    }

    @NonNull
    public String getFolder() {
        return this.folder;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getContentType() {
        return this.contentType;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public CannedAccessControlList getAccessControl() {
        return this.accessControl;
    }

    public static class UploadFileRequestBuilder {
        private InputStream stream;
        private String folder;
        private String name;
        private String contentType;
        private String bucketName;
        private boolean accessControl$set;
        private CannedAccessControlList accessControl$value;

        UploadFileRequestBuilder() {
        }

        public UploadFileRequestBuilder stream(@NonNull InputStream stream) {
            if (stream == null) {
                throw new NullPointerException("stream is marked non-null but is null");
            }
            this.stream = stream;
            return this;
        }

        public UploadFileRequestBuilder folder(@NonNull String folder) {
            if (folder == null) {
                throw new NullPointerException("folder is marked non-null but is null");
            }
            this.folder = folder;
            return this;
        }

        public UploadFileRequestBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public UploadFileRequestBuilder contentType(@NonNull String contentType) {
            if (contentType == null) {
                throw new NullPointerException("contentType is marked non-null but is null");
            }
            this.contentType = contentType;
            return this;
        }

        public UploadFileRequestBuilder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public UploadFileRequestBuilder accessControl(CannedAccessControlList accessControl) {
            this.accessControl$value = accessControl;
            this.accessControl$set = true;
            return this;
        }

        public UploadFileRequest build() {
            CannedAccessControlList accessControl$value = this.accessControl$value;
            if (!this.accessControl$set) {
                accessControl$value = UploadFileRequest.$default$accessControl();
            }
            return new UploadFileRequest(this.stream, this.folder, this.name, this.contentType, this.bucketName, accessControl$value);
        }

        public String toString() {
            return "UploadFileRequest.UploadFileRequestBuilder(stream=" + this.stream + ", folder=" + this.folder + ", name=" + this.name + ", contentType=" + this.contentType + ", bucketName=" + this.bucketName + ", accessControl$value=" + this.accessControl$value + ")";
        }
    }
}

