/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevtech.cloud.storage.spring.config.dropbox;

import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.v2.DbxClientV2;
import com.github.sevtech.cloud.storage.spring.config.ConditionalOnCloudStorageProperty;
import com.github.sevtech.cloud.storage.spring.property.dropbox.DropboxProperties;
import com.github.sevtech.cloud.storage.spring.service.StorageService;
import com.github.sevtech.cloud.storage.spring.service.dropbox.DropboxService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnCloudStorageProperty(value="dropbox.enabled")
public class DropboxConfig {
    private static final Logger log = LoggerFactory.getLogger(DropboxConfig.class);

    @Bean
    public DropboxProperties dropboxProperties() {
        return new DropboxProperties();
    }

    @Bean
    public DbxClientV2 dbxClientV2(DropboxProperties dropboxProperties) {
        log.info("Registering DbxClientV2");
        return new DbxClientV2(DbxRequestConfig.newBuilder((String)dropboxProperties.getClientIdentifier()).build(), dropboxProperties.getAccessToken());
    }

    @Bean
    public StorageService dropboxService(DbxClientV2 dbxClientV2) {
        return new DropboxService(dbxClientV2);
    }
}

