/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.domain;

import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.constant.NodeType;
import com.github.sidhant92.boolparser.domain.Node;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class InNode
extends Node {
    private final String field;
    private final List<Pair<DataType, Object>> items;

    @Override
    public NodeType getTokenType() {
        return NodeType.IN;
    }

    public static InNodeBuilder builder() {
        return new InNodeBuilder();
    }

    public InNode(String field, List<Pair<DataType, Object>> items) {
        this.field = field;
        this.items = items;
    }

    public String getField() {
        return this.field;
    }

    public List<Pair<DataType, Object>> getItems() {
        return this.items;
    }

    public static class InNodeBuilder {
        private String field;
        private List<Pair<DataType, Object>> items;

        InNodeBuilder() {
        }

        public InNodeBuilder field(String field) {
            this.field = field;
            return this;
        }

        public InNodeBuilder items(List<Pair<DataType, Object>> items) {
            this.items = items;
            return this;
        }

        public InNode build() {
            return new InNode(this.field, this.items);
        }

        public String toString() {
            return "InNode.InNodeBuilder(field=" + this.field + ", items=" + this.items + ")";
        }
    }
}

