/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.datatype;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.sidhant92.boolparser.constant.DataType;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataType<T extends Comparable<? super T>> {
    private static final Logger log = LoggerFactory.getLogger(AbstractDataType.class);
    private final Class<T> clazz;

    public AbstractDataType(Class<T> clazz) {
        this.clazz = clazz;
    }

    protected boolean defaultIsValid(Object value, ObjectMapper objectMapper) {
        return this.defaultIsValid(value, objectMapper, false);
    }

    protected boolean defaultIsValid(Object value, ObjectMapper objectMapper, boolean useStrictValidation) {
        try {
            if (this.clazz.isInstance(value)) {
                return true;
            }
            if (useStrictValidation) {
                return false;
            }
            return objectMapper.convertValue(value, this.clazz) != null;
        }
        catch (Exception ex) {
            log.error("Unable to convert value = {} to type = {}", value, this.clazz);
            return false;
        }
    }

    protected Optional<T> defaultGetValue(Object value, ObjectMapper objectMapper) {
        try {
            if (this.clazz.isInstance(value)) {
                return Optional.of(this.clazz.cast(value));
            }
            return Optional.of(objectMapper.convertValue(value, this.clazz));
        }
        catch (Exception ex) {
            log.error("Unable to convert value = {} to type = {}", value, this.clazz);
            return Optional.empty();
        }
    }

    public abstract DataType getDataType();

    public abstract boolean isValid(Object var1);

    public abstract boolean isValid(Object var1, boolean var2);

    public abstract Optional<T> getValue(Object var1);
}

