/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.domain;

import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.constant.NodeType;
import com.github.sidhant92.boolparser.constant.Operator;
import com.github.sidhant92.boolparser.domain.Node;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class ArrayNode
extends Node {
    private final String field;
    private final Operator operator;
    private final List<Pair<DataType, Object>> items;

    @Override
    public NodeType getTokenType() {
        return NodeType.ARRAY;
    }

    public static ArrayNodeBuilder builder() {
        return new ArrayNodeBuilder();
    }

    public ArrayNode(String field, Operator operator, List<Pair<DataType, Object>> items) {
        this.field = field;
        this.operator = operator;
        this.items = items;
    }

    public String getField() {
        return this.field;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public List<Pair<DataType, Object>> getItems() {
        return this.items;
    }

    public static class ArrayNodeBuilder {
        private String field;
        private Operator operator;
        private List<Pair<DataType, Object>> items;

        ArrayNodeBuilder() {
        }

        public ArrayNodeBuilder field(String field) {
            this.field = field;
            return this;
        }

        public ArrayNodeBuilder operator(Operator operator) {
            this.operator = operator;
            return this;
        }

        public ArrayNodeBuilder items(List<Pair<DataType, Object>> items) {
            this.items = items;
            return this;
        }

        public ArrayNode build() {
            return new ArrayNode(this.field, this.operator, this.items);
        }

        public String toString() {
            return "ArrayNode.ArrayNodeBuilder(field=" + this.field + ", operator=" + (Object)((Object)this.operator) + ", items=" + this.items + ")";
        }
    }
}

