/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.operator;

import com.github.sidhant92.boolparser.constant.ContainerDataType;
import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.constant.Operator;
import com.github.sidhant92.boolparser.operator.AbstractOperator;
import com.github.sidhant92.boolparser.operator.InOperator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainsAllOperator
extends AbstractOperator {
    private static final Logger log = LoggerFactory.getLogger(ContainsAllOperator.class);
    private final InOperator inOperator;

    @Override
    public <T extends Comparable<? super T>> boolean evaluate(ContainerDataType containerDataType, DataType dataType, Object leftOperand, Object ... rightOperands) {
        if (!containerDataType.isValid(dataType, leftOperand)) {
            log.error("Validation failed for any operator for the operand {}", leftOperand);
            return false;
        }
        Object[] leftOperandArray = ((List)leftOperand).toArray();
        return Arrays.stream(rightOperands).allMatch(rightOperand -> this.inOperator.evaluate(ContainerDataType.PRIMITIVE, dataType, rightOperand, leftOperandArray));
    }

    @Override
    public Operator getOperator() {
        return Operator.CONTAINS_ALL;
    }

    @Override
    public String getSymbol() {
        return "CONTAINS_ALL";
    }

    @Override
    public List<ContainerDataType> getAllowedContainerTypes() {
        return Collections.singletonList(ContainerDataType.LIST);
    }

    @Override
    public List<DataType> getAllowedDataTypes() {
        return Arrays.asList(DataType.values());
    }

    public ContainsAllOperator(InOperator inOperator) {
        this.inOperator = inOperator;
    }
}

