/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.operator;

import com.github.sidhant92.boolparser.constant.ContainerDataType;
import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.constant.Operator;
import com.github.sidhant92.boolparser.operator.AbstractOperator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class LessThanEqualOperator
extends AbstractOperator {
    @Override
    public <T extends Comparable<? super T>> boolean evaluate(ContainerDataType containerDataType, DataType dataType, Object leftOperand, Object ... rightOperands) {
        Optional<Comparable> leftValueOptional = containerDataType.getValue(dataType, leftOperand);
        Optional rightValueOptional = containerDataType.getValue(dataType, rightOperands[0]);
        return leftValueOptional.flatMap(leftValue -> rightValueOptional.map(leftValue::compareTo).map(a -> a <= 0)).orElse(false);
    }

    @Override
    public Operator getOperator() {
        return Operator.LESS_THAN_EQUAL;
    }

    @Override
    public String getSymbol() {
        return "<=";
    }

    @Override
    public List<ContainerDataType> getAllowedContainerTypes() {
        return Collections.singletonList(ContainerDataType.PRIMITIVE);
    }

    @Override
    public List<DataType> getAllowedDataTypes() {
        return Arrays.asList(DataType.INTEGER, DataType.LONG, DataType.DECIMAL, DataType.STRING, DataType.VERSION);
    }
}

