/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.operator;

import com.github.sidhant92.boolparser.constant.ContainerDataType;
import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.constant.Operator;
import com.github.sidhant92.boolparser.datatype.DataTypeFactory;
import com.github.sidhant92.boolparser.exception.InvalidContainerTypeException;
import com.github.sidhant92.boolparser.exception.InvalidDataType;
import com.github.sidhant92.boolparser.operator.AbstractOperator;
import com.github.sidhant92.boolparser.operator.OperatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorService {
    private static final Logger log = LoggerFactory.getLogger(OperatorService.class);

    public OperatorService() {
        DataTypeFactory.initialize();
        OperatorFactory.initialize();
    }

    public boolean evaluate(Operator operator, ContainerDataType containerDataType, DataType dataType, Object leftOperand, Object ... rightOperands) {
        AbstractOperator abstractOperator = OperatorFactory.getOperator(operator);
        if (!abstractOperator.getAllowedContainerTypes().contains((Object)containerDataType)) {
            log.error("Invalid left container type {} for operator {}", (Object)containerDataType, (Object)operator);
            throw new InvalidContainerTypeException();
        }
        if (!abstractOperator.getAllowedDataTypes().contains((Object)dataType)) {
            log.error("Invalid left operand data type {} for operator {}", (Object)dataType, (Object)operator);
            throw new InvalidDataType();
        }
        if (!containerDataType.isValid(dataType, leftOperand)) {
            log.error("Validation failed for the operator {} for the operand {}", (Object)operator, leftOperand);
            throw new InvalidDataType();
        }
        return OperatorFactory.getOperator(operator).evaluate(containerDataType, dataType, leftOperand, rightOperands);
    }
}

