/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.parser.antlr;

import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.constant.LogicalOperationType;
import com.github.sidhant92.boolparser.constant.Operator;
import com.github.sidhant92.boolparser.domain.ArrayNode;
import com.github.sidhant92.boolparser.domain.BooleanNode;
import com.github.sidhant92.boolparser.domain.ComparisonNode;
import com.github.sidhant92.boolparser.domain.InNode;
import com.github.sidhant92.boolparser.domain.Node;
import com.github.sidhant92.boolparser.domain.NumericRangeNode;
import com.github.sidhant92.boolparser.domain.UnaryNode;
import com.github.sidhant92.boolparser.exception.InvalidExpressionException;
import com.github.sidhant92.boolparser.parser.antlr.BooleanExpressionBaseListener;
import com.github.sidhant92.boolparser.parser.antlr.BooleanExpressionParser;
import com.github.sidhant92.boolparser.util.ValueUtils;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BooleanFilterListener
extends BooleanExpressionBaseListener {
    private static final Logger log = LoggerFactory.getLogger(BooleanFilterListener.class);
    private Node node;
    private final Stack<Node> currentNodes;
    private Token lastToken;
    private String defaultField;

    public BooleanFilterListener(String defaultField) {
        this.defaultField = defaultField;
        this.node = null;
        this.lastToken = null;
        this.currentNodes = new Stack();
    }

    public Node getNode() {
        return this.node;
    }

    @Override
    public void exitComparatorExpression(BooleanExpressionParser.ComparatorExpressionContext ctx) {
        String variableName = this.getField(ctx.left.getText());
        DataType dataType = this.getDataType(ctx.right.getStart());
        Operator operator = Operator.getOperatorFromSymbol(ctx.op.getText()).orElse(Operator.EQUALS);
        this.currentNodes.add(new ComparisonNode(variableName, ValueUtils.convertValue(ctx.right.getText(), dataType), operator, dataType));
        super.enterComparatorExpression(ctx);
    }

    @Override
    public void exitToExpression(BooleanExpressionParser.ToExpressionContext ctx) {
        this.validateField(ctx.field, ctx.getText());
        String field = this.getField(ctx.field.getText());
        DataType lowerDataType = this.getDataType(ctx.lower.start);
        Object lowerValue = ValueUtils.convertValue(ctx.lower.start.getText(), lowerDataType);
        DataType upperDataType = this.getDataType(ctx.upper.start);
        Object upperValue = ValueUtils.convertValue(ctx.upper.getText(), upperDataType);
        this.currentNodes.add(new NumericRangeNode(field, lowerValue, upperValue, lowerDataType, upperDataType));
        super.exitToExpression(ctx);
    }

    @Override
    public void exitArrayExpression(BooleanExpressionParser.ArrayExpressionContext ctx) {
        this.validateField(ctx.field, ctx.getText());
        String field = this.getField(ctx.field.getText());
        List<Pair<DataType, Object>> items = this.getArrayElements(ctx.data.children);
        Operator operator = Operator.getOperatorFromSymbol(ctx.op.getText()).orElse(Operator.EQUALS);
        this.currentNodes.add(new ArrayNode(field, operator, items));
        super.exitArrayExpression(ctx);
    }

    @Override
    public void exitInExpression(BooleanExpressionParser.InExpressionContext ctx) {
        this.validateField(ctx.field, ctx.getText());
        String field = this.getField(ctx.field.getText());
        List<Pair<DataType, Object>> items = this.getArrayElements(ctx.data.children);
        InNode inNode = new InNode(field, items);
        if (Objects.isNull(ctx.not)) {
            this.currentNodes.add(inNode);
        } else {
            BooleanNode booleanNode = new BooleanNode(inNode, null, LogicalOperationType.NOT);
            this.currentNodes.add(booleanNode);
        }
        super.exitInExpression(ctx);
    }

    private List<Pair<DataType, Object>> getArrayElements(List<ParseTree> trees) {
        return trees.stream().filter(child -> child instanceof BooleanExpressionParser.TypesContext).map(child -> {
            DataType dataType = this.getDataType(((BooleanExpressionParser.TypesContext)child).start);
            Object value = ValueUtils.convertValue(child.getText(), dataType);
            return Pair.of((Object)((Object)dataType), (Object)value);
        }).collect(Collectors.toList());
    }

    private void validateField(Token token, String text) {
        if (Objects.isNull(token) || StringUtils.isBlank((CharSequence)token.getText()) && StringUtils.isBlank((CharSequence)this.defaultField)) {
            log.error("Error parsing expression (missing field) for the string {}", (Object)text);
            throw new InvalidExpressionException();
        }
    }

    private String getField(String field) {
        return StringUtils.isBlank((CharSequence)field) ? this.defaultField : field;
    }

    private DataType getDataType(Token token) {
        switch (token.getType()) {
            case 19: {
                return DataType.DECIMAL;
            }
            case 21: {
                return ValueUtils.getNumericDataType(token.getText());
            }
            case 20: {
                return DataType.VERSION;
            }
            case 7: 
            case 8: {
                return DataType.BOOLEAN;
            }
        }
        return DataType.STRING;
    }

    private LogicalOperationType getLogicalOperator(Token token) {
        switch (token.getType()) {
            case 4: {
                return LogicalOperationType.AND;
            }
            case 5: {
                return LogicalOperationType.OR;
            }
        }
        return LogicalOperationType.NOT;
    }

    @Override
    public void exitParse(BooleanExpressionParser.ParseContext ctx) {
        if (this.node != null || this.currentNodes.size() != 1) {
            log.error("Error parsing expression for the string {}", (Object)ctx.getText());
            throw new InvalidExpressionException();
        }
        this.node = this.currentNodes.pop();
        super.exitParse(ctx);
    }

    @Override
    public void exitNotExpression(BooleanExpressionParser.NotExpressionContext ctx) {
        if (this.currentNodes.isEmpty()) {
            if (this.lastToken == null) {
                log.error("Error parsing not expression for the string {}", (Object)ctx.getText());
                throw new InvalidExpressionException();
            }
            DataType dataType = this.getDataType(this.lastToken);
            Object value = ValueUtils.convertValue(this.lastToken.getText(), dataType);
            this.currentNodes.add(new UnaryNode(dataType, value));
        }
        BooleanNode booleanToken = new BooleanNode(this.currentNodes.pop(), null, LogicalOperationType.NOT);
        this.currentNodes.add(booleanToken);
        super.exitNotExpression(ctx);
    }

    @Override
    public void exitTypesExpression(BooleanExpressionParser.TypesExpressionContext ctx) {
        this.lastToken = ctx.start;
    }

    @Override
    public void exitBinaryExpression(BooleanExpressionParser.BinaryExpressionContext ctx) {
        if (this.currentNodes.size() < 2) {
            log.error("Error parsing binary expression for the string {}", (Object)ctx.getText());
            throw new InvalidExpressionException();
        }
        Node firstNode = this.currentNodes.pop();
        Node secondNode = this.currentNodes.pop();
        LogicalOperationType operator = this.getLogicalOperator(ctx.op.getStart());
        BooleanNode booleanToken = new BooleanNode(secondNode, firstNode, operator);
        this.currentNodes.add(booleanToken);
        super.enterBinaryExpression(ctx);
    }
}

