/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.application;

import com.github.sidhant92.boolparser.application.ArithmeticExpressionEvaluator;
import com.github.sidhant92.boolparser.constant.ContainerDataType;
import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.constant.Operator;
import com.github.sidhant92.boolparser.domain.EvaluatedNode;
import com.github.sidhant92.boolparser.domain.FieldNode;
import com.github.sidhant92.boolparser.domain.arithmetic.ArithmeticBaseNode;
import com.github.sidhant92.boolparser.domain.arithmetic.UnaryNode;
import com.github.sidhant92.boolparser.domain.logical.ArrayNode;
import com.github.sidhant92.boolparser.domain.logical.BooleanNode;
import com.github.sidhant92.boolparser.domain.logical.ComparisonNode;
import com.github.sidhant92.boolparser.domain.logical.InNode;
import com.github.sidhant92.boolparser.domain.logical.Node;
import com.github.sidhant92.boolparser.domain.logical.NumericRangeNode;
import com.github.sidhant92.boolparser.exception.DataNotFoundException;
import com.github.sidhant92.boolparser.exception.HeterogeneousArrayException;
import com.github.sidhant92.boolparser.exception.InvalidUnaryOperand;
import com.github.sidhant92.boolparser.operator.OperatorService;
import com.github.sidhant92.boolparser.parser.BoolExpressionParser;
import com.github.sidhant92.boolparser.util.ValueUtils;
import io.vavr.control.Try;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class BooleanExpressionEvaluator {
    private final BoolExpressionParser boolExpressionParser;
    private final OperatorService operatorService;
    private final ArithmeticExpressionEvaluator arithmeticExpressionEvaluator;

    public BooleanExpressionEvaluator(BoolExpressionParser boolExpressionParser) {
        this.boolExpressionParser = boolExpressionParser;
        this.operatorService = new OperatorService();
        this.arithmeticExpressionEvaluator = new ArithmeticExpressionEvaluator(boolExpressionParser);
    }

    public Try<Boolean> evaluate(String expression, Map<String, Object> data, String defaultField) {
        Try<Node> tokenOptional = this.boolExpressionParser.parseExpression(expression, defaultField);
        return tokenOptional.map(node -> this.evaluateToken((Node)node, data));
    }

    public Try<Boolean> evaluate(String expression, Map<String, Object> data) {
        return this.evaluate(expression, data, null);
    }

    private boolean evaluateToken(Node node, Map<String, Object> data) {
        switch (node.getTokenType()) {
            case COMPARISON: {
                return this.evaluateComparisonToken((ComparisonNode)node, data);
            }
            case NUMERIC_RANGE: {
                return this.evaluateNumericRangeToken((NumericRangeNode)node, data);
            }
            case IN: {
                return this.evaluateInToken((InNode)node, data);
            }
            case ARRAY: {
                return this.evaluateArrayToken((ArrayNode)node, data);
            }
            case UNARY: {
                return this.evaluateUnaryToken((UnaryNode)node, data);
            }
            case BOOLEAN: {
                return this.evaluateBooleanNode((BooleanNode)node, data);
            }
        }
        return false;
    }

    private Optional<Object> getValue(Node node, Map<String, Object> data) {
        switch (node.getTokenType()) {
            case FIELD: {
                return ValueUtils.getValueFromMap(((FieldNode)node).getField(), data);
            }
            case UNARY: {
                UnaryNode unaryNode = (UnaryNode)node;
                return Optional.of(unaryNode.getValue());
            }
        }
        if (node instanceof ArithmeticBaseNode) {
            return Optional.of(this.arithmeticExpressionEvaluator.evaluate(node, data));
        }
        return Optional.of(this.evaluateToken(node, data));
    }

    private boolean evaluateComparisonToken(ComparisonNode comparisonToken, Map<String, Object> data) {
        Optional<Object> leftValueOptional = this.getValue(comparisonToken.getLeft(), data);
        Object leftData = comparisonToken.isNullCheck() ? leftValueOptional.orElse("null") : leftValueOptional.orElseThrow(() -> new DataNotFoundException(((FieldNode)comparisonToken.getLeft()).getField()));
        String rightData = comparisonToken.isNullCheck() ? "null" : this.getValue(comparisonToken.getRight(), data).get();
        DataType rightDataType = ValueUtils.getDataType(rightData);
        DataType leftDataType = ValueUtils.getDataType(leftData);
        return this.operatorService.evaluateLogicalOperator(comparisonToken.getOperator(), ContainerDataType.PRIMITIVE, leftData, leftDataType, Collections.singletonList(Pair.of((Object)rightData, (Object)((Object)rightDataType))));
    }

    private boolean evaluateNumericRangeToken(NumericRangeNode numericRangeToken, Map<String, Object> data) {
        Object fieldData = ValueUtils.getValueFromMap(numericRangeToken.getField(), data).orElseThrow(() -> new DataNotFoundException(numericRangeToken.getField()));
        DataType fieldDataType = ValueUtils.getDataType(fieldData);
        List<Pair<Object, DataType>> fromValues = Collections.singletonList(Pair.of((Object)numericRangeToken.getFromValue(), (Object)((Object)numericRangeToken.getFromDataType())));
        List<Pair<Object, DataType>> toValues = Collections.singletonList(Pair.of((Object)numericRangeToken.getToValue(), (Object)((Object)numericRangeToken.getToDataType())));
        boolean leftResult = this.operatorService.evaluateLogicalOperator(Operator.GREATER_THAN_EQUAL, ContainerDataType.PRIMITIVE, fieldData, fieldDataType, fromValues);
        boolean rightResult = this.operatorService.evaluateLogicalOperator(Operator.LESS_THAN_EQUAL, ContainerDataType.PRIMITIVE, fieldData, fieldDataType, toValues);
        return leftResult && rightResult;
    }

    private boolean evaluateInToken(InNode inToken, Map<String, Object> data) {
        Object fieldData = ValueUtils.getValueFromMap(inToken.getField(), data).orElseThrow(() -> new DataNotFoundException(inToken.getField()));
        List<EvaluatedNode> items = this.resolveArrayElements(inToken.getItems(), data);
        DataType dataType = ValueUtils.getDataType(fieldData);
        List<Pair<Object, DataType>> values = items.stream().map(item -> Pair.of((Object)item.getValue(), (Object)((Object)item.getDataType()))).collect(Collectors.toList());
        return this.operatorService.evaluateLogicalOperator(Operator.IN, ContainerDataType.PRIMITIVE, fieldData, dataType, values);
    }

    private List<EvaluatedNode> resolveArrayElements(List<Node> items, Map<String, Object> data) {
        List<Object> resolvedValues = items.stream().map(item -> {
            if (item instanceof ArithmeticBaseNode) {
                return this.arithmeticExpressionEvaluator.evaluate((Node)item, data);
            }
            return this.evaluateToken((Node)item, data);
        }).collect(Collectors.toList());
        return ValueUtils.mapToEvaluatedNodes(resolvedValues);
    }

    private boolean evaluateArrayToken(ArrayNode arrayNode, Map<String, Object> data) {
        Object fieldData = ValueUtils.getValueFromMap(arrayNode.getField(), data).orElseThrow(() -> new DataNotFoundException(arrayNode.getField()));
        DataType fieldDataType = ValueUtils.getDataType(fieldData);
        List<EvaluatedNode> items = this.resolveArrayElements(arrayNode.getItems(), data);
        if (items.stream().map(EvaluatedNode::getDataType).distinct().count() > 1L) {
            throw new HeterogeneousArrayException();
        }
        List<Pair<Object, DataType>> values = items.stream().map(item -> Pair.of((Object)item.getValue(), (Object)((Object)item.getDataType()))).collect(Collectors.toList());
        return this.operatorService.evaluateLogicalOperator(arrayNode.getOperator(), ContainerDataType.LIST, fieldData, fieldDataType, values);
    }

    private boolean evaluateUnaryToken(UnaryNode unaryToken, Map<String, Object> data) {
        if (unaryToken.getDataType().equals((Object)DataType.BOOLEAN)) {
            return (Boolean)unaryToken.getValue();
        }
        Object fieldData = ValueUtils.getValueFromMap(unaryToken.getValue().toString(), data).orElseThrow(() -> new DataNotFoundException(unaryToken.getValue().toString()));
        if (!(fieldData instanceof Boolean)) {
            throw new InvalidUnaryOperand();
        }
        return (Boolean)fieldData;
    }

    private boolean evaluateBooleanNode(BooleanNode booleanToken, Map<String, Object> data) {
        switch (booleanToken.getOperator()) {
            case AND: {
                return this.evaluateToken(booleanToken.getLeft(), data) && this.evaluateToken(booleanToken.getRight(), data);
            }
            case OR: {
                return this.evaluateToken(booleanToken.getLeft(), data) || this.evaluateToken(booleanToken.getRight(), data);
            }
        }
        return !this.evaluateToken(booleanToken.getLeft(), data);
    }
}

