/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.datatype;

import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.datatype.AbstractDataType;
import com.github.sidhant92.boolparser.datatype.BooleanDataType;
import com.github.sidhant92.boolparser.datatype.DateDataType;
import com.github.sidhant92.boolparser.datatype.DateTimeDataType;
import com.github.sidhant92.boolparser.datatype.DecimalDataType;
import com.github.sidhant92.boolparser.datatype.IntegerDataType;
import com.github.sidhant92.boolparser.datatype.LongDataType;
import com.github.sidhant92.boolparser.datatype.StringDataType;
import com.github.sidhant92.boolparser.datatype.VersionDataType;
import java.util.EnumMap;
import java.util.Map;

public class DataTypeFactory {
    private static final Map<DataType, AbstractDataType<?>> abstractDataTypeMap = new EnumMap(DataType.class);

    private DataTypeFactory() {
    }

    public static void initialize() {
        abstractDataTypeMap.put(DataType.STRING, new StringDataType());
        abstractDataTypeMap.put(DataType.INTEGER, new IntegerDataType());
        abstractDataTypeMap.put(DataType.DECIMAL, new DecimalDataType());
        abstractDataTypeMap.put(DataType.LONG, new LongDataType());
        abstractDataTypeMap.put(DataType.VERSION, new VersionDataType());
        abstractDataTypeMap.put(DataType.BOOLEAN, new BooleanDataType());
        abstractDataTypeMap.put(DataType.DATE, new DateDataType());
        abstractDataTypeMap.put(DataType.DATETIME, new DateTimeDataType());
    }

    public static AbstractDataType getDataType(DataType dataType) {
        return abstractDataTypeMap.get((Object)dataType);
    }

    public static void register(AbstractDataType abstractDataType) {
        abstractDataTypeMap.put(abstractDataType.getDataType(), abstractDataType);
    }
}

