/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.datatype;

import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.datatype.AbstractDataType;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Optional;

public class DateTimeDataType
extends AbstractDataType<LocalDateTime> {
    private static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public DateTimeDataType() {
        super(LocalDateTime.class);
    }

    @Override
    public DataType getDataType() {
        return DataType.DATETIME;
    }

    @Override
    public boolean isValid(Object value) {
        boolean isValid = super.defaultIsValid(value);
        if (!isValid) {
            return this.parseDateTime(value.toString()).isPresent();
        }
        return true;
    }

    @Override
    public boolean isValid(Object value, boolean useStrictValidation) {
        if (!useStrictValidation) {
            return this.isValid(value);
        }
        return super.defaultIsValid(value);
    }

    @Override
    public Optional<LocalDateTime> getValue(Object value) {
        Optional<LocalDateTime> result = this.defaultGetValue(value);
        if (result.isPresent()) {
            return result;
        }
        return this.parseDateTime(value.toString());
    }

    private Optional<LocalDateTime> parseDateTime(String dateTimeString) {
        try {
            return Optional.of(LocalDateTime.parse(dateTimeString, DATETIME_FORMATTER));
        }
        catch (DateTimeParseException ignored) {
            return Optional.empty();
        }
    }
}

