/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.function;

import com.github.sidhant92.boolparser.constant.FunctionType;
import com.github.sidhant92.boolparser.function.arithmetic.AbstractFunction;
import com.github.sidhant92.boolparser.function.arithmetic.AvgFunction;
import com.github.sidhant92.boolparser.function.arithmetic.DaysElapsedFunction;
import com.github.sidhant92.boolparser.function.arithmetic.IntFunction;
import com.github.sidhant92.boolparser.function.arithmetic.LenFunction;
import com.github.sidhant92.boolparser.function.arithmetic.MaxFunction;
import com.github.sidhant92.boolparser.function.arithmetic.MeanFunction;
import com.github.sidhant92.boolparser.function.arithmetic.MedianFunction;
import com.github.sidhant92.boolparser.function.arithmetic.MinFunction;
import com.github.sidhant92.boolparser.function.arithmetic.ModeFunction;
import com.github.sidhant92.boolparser.function.arithmetic.SumFunction;
import java.util.EnumMap;
import java.util.Map;

public class FunctionFactory {
    private static final Map<FunctionType, AbstractFunction> arithmeticFunctionrMap = new EnumMap<FunctionType, AbstractFunction>(FunctionType.class);

    private FunctionFactory() {
    }

    public static void initialize() {
        arithmeticFunctionrMap.put(FunctionType.MIN, new MinFunction());
        arithmeticFunctionrMap.put(FunctionType.MAX, new MaxFunction());
        arithmeticFunctionrMap.put(FunctionType.AVG, new AvgFunction());
        arithmeticFunctionrMap.put(FunctionType.SUM, new SumFunction());
        arithmeticFunctionrMap.put(FunctionType.MEAN, new MeanFunction());
        arithmeticFunctionrMap.put(FunctionType.MEDIAN, new MedianFunction());
        arithmeticFunctionrMap.put(FunctionType.MODE, new ModeFunction());
        arithmeticFunctionrMap.put(FunctionType.INT, new IntFunction());
        arithmeticFunctionrMap.put(FunctionType.LEN, new LenFunction());
        arithmeticFunctionrMap.put(FunctionType.DAYS_ELAPSED, new DaysElapsedFunction());
    }

    public static AbstractFunction getArithmeticFunction(FunctionType functionType) {
        return arithmeticFunctionrMap.get((Object)functionType);
    }
}

