/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.function.arithmetic;

import com.github.sidhant92.boolparser.constant.ContainerDataType;
import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.constant.FunctionType;
import com.github.sidhant92.boolparser.domain.EvaluatedNode;
import com.github.sidhant92.boolparser.exception.InvalidFunctionArgument;
import com.github.sidhant92.boolparser.function.arithmetic.AbstractFunction;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;

public class DaysElapsedFunction
extends AbstractFunction {
    @Override
    public Object evaluate(List<EvaluatedNode> items) {
        LocalDate inputDate;
        if (items.size() != 1) {
            throw new InvalidFunctionArgument("DAYS_ELAPSED function requires exactly one argument");
        }
        EvaluatedNode item = items.get(0);
        Object value = item.getValue();
        if (value instanceof LocalDate) {
            inputDate = (LocalDate)value;
        } else if (value instanceof String) {
            try {
                inputDate = LocalDate.parse((String)value);
            }
            catch (Exception e) {
                throw new InvalidFunctionArgument("DAYS_ELAPSED function requires a valid date argument, got: " + String.valueOf(value));
            }
        } else {
            throw new InvalidFunctionArgument("DAYS_ELAPSED function requires a date argument, got: " + value.getClass().getSimpleName());
        }
        LocalDate today = LocalDate.now();
        return ChronoUnit.DAYS.between(inputDate, today);
    }

    @Override
    public FunctionType getFunctionType() {
        return FunctionType.DAYS_ELAPSED;
    }

    @Override
    public List<ContainerDataType> getAllowedContainerTypes() {
        return Arrays.asList(ContainerDataType.PRIMITIVE);
    }

    @Override
    public List<DataType> getAllowedDataTypes() {
        return Arrays.asList(DataType.DATE);
    }
}

