/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.operator;

import com.github.sidhant92.boolparser.constant.Operator;
import com.github.sidhant92.boolparser.operator.arithmetic.AbstractOperator;
import com.github.sidhant92.boolparser.operator.arithmetic.AddOperator;
import com.github.sidhant92.boolparser.operator.arithmetic.DivideOperator;
import com.github.sidhant92.boolparser.operator.arithmetic.ExponentOperator;
import com.github.sidhant92.boolparser.operator.arithmetic.ModulusOperator;
import com.github.sidhant92.boolparser.operator.arithmetic.MultiplyOperator;
import com.github.sidhant92.boolparser.operator.arithmetic.SubtractOperator;
import com.github.sidhant92.boolparser.operator.arithmetic.UnaryOperator;
import com.github.sidhant92.boolparser.operator.comparison.ContainsAllOperator;
import com.github.sidhant92.boolparser.operator.comparison.ContainsAnyOperator;
import com.github.sidhant92.boolparser.operator.comparison.EqualsOperator;
import com.github.sidhant92.boolparser.operator.comparison.GreaterThanEqualOperator;
import com.github.sidhant92.boolparser.operator.comparison.GreaterThanOperator;
import com.github.sidhant92.boolparser.operator.comparison.InOperator;
import com.github.sidhant92.boolparser.operator.comparison.LessThanEqualOperator;
import com.github.sidhant92.boolparser.operator.comparison.LessThanOperator;
import com.github.sidhant92.boolparser.operator.comparison.NotEqualsOperator;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class OperatorFactory {
    private static final Map<Operator, com.github.sidhant92.boolparser.operator.comparison.AbstractOperator> logicalOperatorMap = new EnumMap<Operator, com.github.sidhant92.boolparser.operator.comparison.AbstractOperator>(Operator.class);
    private static final Map<Operator, AbstractOperator> arithmeticOperatorMap = new EnumMap<Operator, AbstractOperator>(Operator.class);

    private OperatorFactory() {
    }

    public static void initialize() {
        EqualsOperator equalsOperator = new EqualsOperator();
        InOperator inOperator = new InOperator(equalsOperator);
        logicalOperatorMap.put(Operator.EQUALS, equalsOperator);
        logicalOperatorMap.put(Operator.GREATER_THAN, new GreaterThanOperator());
        logicalOperatorMap.put(Operator.GREATER_THAN_EQUAL, new GreaterThanEqualOperator());
        logicalOperatorMap.put(Operator.LESS_THAN, new LessThanOperator());
        logicalOperatorMap.put(Operator.LESS_THAN_EQUAL, new LessThanEqualOperator());
        logicalOperatorMap.put(Operator.NOT_EQUAL, new NotEqualsOperator());
        logicalOperatorMap.put(Operator.IN, new InOperator(equalsOperator));
        logicalOperatorMap.put(Operator.CONTAINS_ALL, new ContainsAllOperator(inOperator));
        logicalOperatorMap.put(Operator.CONTAINS_ANY, new ContainsAnyOperator(inOperator));
        arithmeticOperatorMap.put(Operator.ADD, new AddOperator());
        arithmeticOperatorMap.put(Operator.SUBTRACT, new SubtractOperator());
        arithmeticOperatorMap.put(Operator.DIVIDE, new DivideOperator());
        arithmeticOperatorMap.put(Operator.MULTIPLY, new MultiplyOperator());
        arithmeticOperatorMap.put(Operator.EXPONENT, new ExponentOperator());
        arithmeticOperatorMap.put(Operator.MODULUS, new ModulusOperator());
        arithmeticOperatorMap.put(Operator.UNARY, new UnaryOperator());
    }

    public static com.github.sidhant92.boolparser.operator.comparison.AbstractOperator getLogicalOperator(Operator operator) {
        return logicalOperatorMap.get((Object)operator);
    }

    public static AbstractOperator getArithmeticOperator(Operator operator) {
        return arithmeticOperatorMap.get((Object)operator);
    }

    public static List<com.github.sidhant92.boolparser.operator.comparison.AbstractOperator> getAllLogicalOperators() {
        return new ArrayList<com.github.sidhant92.boolparser.operator.comparison.AbstractOperator>(logicalOperatorMap.values());
    }

    public static List<AbstractOperator> getAllArithmeticOperators() {
        return new ArrayList<AbstractOperator>(arithmeticOperatorMap.values());
    }
}

