/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.operator;

import com.github.sidhant92.boolparser.constant.ContainerDataType;
import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.constant.Operator;
import com.github.sidhant92.boolparser.datatype.DataTypeFactory;
import com.github.sidhant92.boolparser.exception.InvalidContainerTypeException;
import com.github.sidhant92.boolparser.exception.InvalidDataType;
import com.github.sidhant92.boolparser.operator.OperatorFactory;
import com.github.sidhant92.boolparser.operator.arithmetic.AbstractOperator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;

public class OperatorService {
    public OperatorService() {
        DataTypeFactory.initialize();
        OperatorFactory.initialize();
    }

    public boolean evaluateLogicalOperator(Operator operator, ContainerDataType containerDataType, Object leftOperand, DataType leftOperandDataType, List<Pair<Object, DataType>> rightOperands) {
        com.github.sidhant92.boolparser.operator.comparison.AbstractOperator abstractOperator = OperatorFactory.getLogicalOperator(operator);
        if (!abstractOperator.getAllowedContainerTypes().contains((Object)containerDataType)) {
            throw new InvalidContainerTypeException(String.format("Invalid left container type %s for operator %s", new Object[]{containerDataType, operator}));
        }
        if (!abstractOperator.getAllowedDataTypes().contains((Object)leftOperandDataType)) {
            throw new InvalidDataType(String.format("Invalid left operand data type %s for operator %s", new Object[]{leftOperandDataType, operator}));
        }
        if (!containerDataType.isValid(leftOperandDataType, leftOperand)) {
            throw new InvalidDataType(String.format("Validation failed for the operator %s for the operand %s", new Object[]{operator, leftOperand}));
        }
        rightOperands.forEach(rightOperand -> {
            if (!abstractOperator.getAllowedDataTypes().contains(rightOperand.getRight())) {
                throw new InvalidDataType(String.format("Invalid right operand data type %s for operator %s", new Object[]{rightOperand.getRight(), operator}));
            }
        });
        return OperatorFactory.getLogicalOperator(operator).evaluate(containerDataType, leftOperand, leftOperandDataType, rightOperands);
    }

    public Object evaluateArithmeticOperator(Object leftOperand, DataType leftDataType, Object rightOperand, DataType rightDataType, Operator operator, ContainerDataType containerDataType) {
        AbstractOperator abstractOperator = OperatorFactory.getArithmeticOperator(operator);
        if (!abstractOperator.getAllowedContainerTypes().contains((Object)containerDataType)) {
            throw new InvalidContainerTypeException(String.format("Invalid left container type %s for operator %s", new Object[]{containerDataType, operator}));
        }
        if (!abstractOperator.getAllowedDataTypes().contains((Object)leftDataType)) {
            throw new InvalidDataType(String.format("Invalid left operand data type %s for operator %s", new Object[]{leftDataType, operator}));
        }
        if (!containerDataType.isValid(leftDataType, leftOperand)) {
            throw new InvalidDataType(String.format("Validation failed for the operator %s for the operand %s", new Object[]{operator, leftOperand}));
        }
        if (Objects.nonNull((Object)rightDataType) && !abstractOperator.getAllowedDataTypes().contains((Object)rightDataType)) {
            throw new InvalidDataType(String.format("Invalid left operand data type %s for operator %s", new Object[]{rightDataType, operator}));
        }
        if (Objects.nonNull(rightOperand) && !containerDataType.isValid(rightDataType, rightOperand)) {
            throw new InvalidDataType(String.format("Validation failed for the operator %s for the operand %s", new Object[]{operator, rightDataType}));
        }
        return OperatorFactory.getArithmeticOperator(operator).evaluate(leftOperand, leftDataType, rightOperand, rightDataType);
    }
}

