/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.operator.arithmetic;

import com.github.sidhant92.boolparser.constant.ContainerDataType;
import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.constant.Operator;
import com.github.sidhant92.boolparser.datatype.DataTypeFactory;
import com.github.sidhant92.boolparser.datatype.DecimalDataType;
import com.github.sidhant92.boolparser.datatype.LongDataType;
import com.github.sidhant92.boolparser.operator.arithmetic.AbstractOperator;
import com.github.sidhant92.boolparser.util.ValueUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MultiplyOperator
extends AbstractOperator {
    @Override
    public Object evaluate(Object leftOperand, DataType leftOperandDataType, Object rightOperand, DataType rightOperandDataType) {
        if (leftOperandDataType.equals((Object)DataType.DECIMAL) || rightOperandDataType.equals((Object)DataType.DECIMAL)) {
            DecimalDataType decimalDataType = (DecimalDataType)DataTypeFactory.getDataType(DataType.DECIMAL);
            return decimalDataType.getValue(leftOperand).get().multiply(decimalDataType.getValue(rightOperand).get());
        }
        LongDataType longDataType = (LongDataType)DataTypeFactory.getDataType(DataType.LONG);
        return ValueUtils.castLong(longDataType.getValue(leftOperand).get() * longDataType.getValue(rightOperand).get());
    }

    @Override
    public Operator getOperator() {
        return Operator.MULTIPLY;
    }

    @Override
    public String getSymbol() {
        return "*";
    }

    @Override
    public List<ContainerDataType> getAllowedContainerTypes() {
        return Collections.singletonList(ContainerDataType.PRIMITIVE);
    }

    @Override
    public List<DataType> getAllowedDataTypes() {
        return Arrays.asList(DataType.INTEGER, DataType.LONG, DataType.DECIMAL);
    }
}

