/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.operator.comparison;

import com.github.sidhant92.boolparser.constant.ContainerDataType;
import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.constant.Operator;
import com.github.sidhant92.boolparser.operator.comparison.AbstractOperator;
import com.github.sidhant92.boolparser.operator.comparison.NumericOperator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;

public class LessThanOperator
extends AbstractOperator
implements NumericOperator {
    @Override
    public <T extends Comparable<? super T>> boolean evaluate(ContainerDataType containerDataType, Object leftOperand, DataType leftOperandDataType, List<Pair<Object, DataType>> rightOperands) {
        this.validate(leftOperand, leftOperandDataType, rightOperands.get(0).getLeft(), (DataType)((Object)rightOperands.get(0).getRight()), containerDataType);
        DataType comparisonType = this.getComparableDataType(leftOperandDataType, (DataType)((Object)rightOperands.get(0).getRight()));
        Optional<Comparable> leftValueOptional = containerDataType.getValue(comparisonType, leftOperand);
        Optional rightValueOptional = containerDataType.getValue(comparisonType, rightOperands.get(0).getLeft());
        return leftValueOptional.flatMap(leftValue -> rightValueOptional.map(leftValue::compareTo).map(a -> a < 0)).orElse(false);
    }

    @Override
    public Operator getOperator() {
        return Operator.LESS_THAN;
    }

    @Override
    public String getSymbol() {
        return "<";
    }

    @Override
    public List<ContainerDataType> getAllowedContainerTypes() {
        return Collections.singletonList(ContainerDataType.PRIMITIVE);
    }

    @Override
    public List<DataType> getAllowedDataTypes() {
        return Arrays.asList(DataType.INTEGER, DataType.LONG, DataType.DECIMAL, DataType.STRING, DataType.VERSION, DataType.DATE, DataType.DATETIME);
    }
}

