/*
 * Decompiled with CFR 0.152.
 */
package com.github.silent.samurai.speedy.api.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.silent.samurai.speedy.api.client.HttpClient;
import com.github.silent.samurai.speedy.api.client.SpeedyQuery;
import com.github.silent.samurai.speedy.api.client.models.SpeedyCreateRequest;
import com.github.silent.samurai.speedy.api.client.models.SpeedyDeleteRequest;
import com.github.silent.samurai.speedy.api.client.models.SpeedyGetRequest;
import com.github.silent.samurai.speedy.api.client.models.SpeedyUpdateRequest;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class SpeedyApi<T> {
    private final HttpClient<T> httpClient;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final String baseUrl;

    public SpeedyApi(HttpClient<T> httpClient) {
        this.httpClient = httpClient;
        this.baseUrl = "/speedy/v1/";
    }

    public T create(SpeedyCreateRequest speedyCreateRequest) throws Exception {
        ArrayNode arrayNode = this.objectMapper.createArrayNode();
        arrayNode.add(speedyCreateRequest.getBody());
        speedyCreateRequest.setBody((JsonNode)arrayNode);
        return this.createMany(speedyCreateRequest);
    }

    public T createMany(SpeedyCreateRequest speedyCreateRequest) throws Exception {
        return this.invokeAPI(this.baseUrl + speedyCreateRequest.getEntity() + "/$create", HttpMethod.POST, speedyCreateRequest.getBody());
    }

    public T update(SpeedyUpdateRequest speedyUpdateRequest) throws Exception {
        String path = this.baseUrl + speedyUpdateRequest.getEntity() + "/$update";
        return this.invokeAPI(path, HttpMethod.PATCH, speedyUpdateRequest.getBody());
    }

    public T delete(SpeedyDeleteRequest request) throws Exception {
        String path = this.baseUrl + request.getEntity() + "/$delete";
        return this.invokeAPI(path, HttpMethod.DELETE, (JsonNode)request.getPkToDelete());
    }

    public T get(SpeedyGetRequest request) throws Exception {
        String path = this.baseUrl + request.getEntity() + this.formatPrimaryKey((JsonNode)request.getPk());
        return this.invokeAPI(path, HttpMethod.GET, null);
    }

    public T query(SpeedyQuery speedyQuery) throws Exception {
        String path = this.baseUrl + speedyQuery.getFrom() + "/$query/";
        JsonNode body = speedyQuery.build();
        return this.invokeAPI(path, HttpMethod.POST, body);
    }

    private T invokeAPI(String path, HttpMethod method, JsonNode body) throws Exception {
        return this.httpClient.invokeAPI(path, method, (MultiValueMap<String, String>)new LinkedMultiValueMap(), body, new HttpHeaders());
    }

    private String formatPrimaryKey(JsonNode pk) {
        if (pk == null || !pk.fields().hasNext()) {
            return "";
        }
        Stream<Map.Entry> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(pk.fields(), 16), false);
        String formattedPk = stream.map(e -> String.format("%s='%s'", e.getKey(), ((JsonNode)e.getValue()).asText())).collect(Collectors.joining("&"));
        return "?" + formattedPk;
    }

    private HttpHeaders createHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        return headers;
    }

    public HttpClient<T> getHttpClient() {
        return this.httpClient;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }
}

