/*
 * Decompiled with CFR 0.152.
 */
package com.github.silent.samurai.speedy.api.client;

import com.github.silent.samurai.speedy.api.client.HttpClient;
import com.github.silent.samurai.speedy.api.client.SpeedyApi;
import com.github.silent.samurai.speedy.api.client.SpeedyQuery;
import com.github.silent.samurai.speedy.api.client.builder.SpeedyCreateRequestBuilder;
import com.github.silent.samurai.speedy.api.client.builder.SpeedyDeleteRequestBuilder;
import com.github.silent.samurai.speedy.api.client.builder.SpeedyGetRequestBuilder;
import com.github.silent.samurai.speedy.api.client.builder.SpeedyUpdateRequestBuilder;
import com.github.silent.samurai.speedy.api.client.clients.MockMvcHttpClient;
import com.github.silent.samurai.speedy.api.client.clients.RestTemplateSpeedyClientImpl;
import com.github.silent.samurai.speedy.api.client.models.SpeedyQueryRequest;
import com.github.silent.samurai.speedy.api.client.models.SpeedyResponse;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.web.client.RestTemplate;

public class SpeedyClient<T> {
    private final SpeedyApi<T> speedyApi;

    public SpeedyClient(HttpClient<T> httpClient) {
        this.speedyApi = new SpeedyApi<T>(httpClient);
    }

    public static SpeedyClient<SpeedyResponse> restTemplate(RestTemplate restTemplate, String baseUrl) {
        return new SpeedyClient<SpeedyResponse>(new RestTemplateSpeedyClientImpl(restTemplate, baseUrl));
    }

    public static SpeedyClient<ResultActions> mockMvc(MockMvc mockMvc) {
        return new SpeedyClient<ResultActions>(new MockMvcHttpClient(mockMvc));
    }

    public static <T> SpeedyClient<T> from(HttpClient<T> httpClient) {
        return new SpeedyClient<T>(httpClient);
    }

    public SpeedyUpdateRequestBuilder<T> update(String entityName) {
        return new SpeedyUpdateRequestBuilder<T>(entityName, this.speedyApi);
    }

    public SpeedyGetRequestBuilder<T> get(String entityName) {
        return new SpeedyGetRequestBuilder<T>(entityName, this.speedyApi);
    }

    public SpeedyDeleteRequestBuilder<T> delete(String entityName) {
        return new SpeedyDeleteRequestBuilder<T>(entityName, this.speedyApi);
    }

    public SpeedyCreateRequestBuilder<T> create(String entityName) {
        return new SpeedyCreateRequestBuilder<T>(entityName, this.speedyApi);
    }

    public SpeedyQueryRequest<T> query(SpeedyQuery query) {
        return new SpeedyQueryRequest<T>(query, this.speedyApi);
    }
}

