/*
 * Decompiled with CFR 0.152.
 */
package com.github.silent.samurai.speedy.api.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.github.silent.samurai.speedy.utils.CommonUtil;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeedyQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpeedyQuery.class);
    private final ObjectNode root = CommonUtil.json().createObjectNode();
    private final ObjectNode where = CommonUtil.json().createObjectNode();
    private final ObjectNode orderBy = CommonUtil.json().createObjectNode();
    private final ArrayNode expand = CommonUtil.json().createArrayNode();
    private final Set<String> select = new HashSet<String>();
    int pageNo = 0;
    int pageSize = 10;

    public static SpeedyQuery from(@NotNull String entity) {
        return new SpeedyQuery().fromEntity(entity);
    }

    public static SpeedyQuery from() {
        return new SpeedyQuery();
    }

    private static ObjectNode toJsonNode(Object value, String condition) throws JsonProcessingException {
        ObjectNode jsonNodes = CommonUtil.json().createObjectNode();
        JsonNode jsonNode = (JsonNode)CommonUtil.json().convertValue(value, JsonNode.class);
        jsonNodes.set(condition, jsonNode);
        return jsonNodes;
    }

    public static ObjectNode eq(@NotNull Object value) throws JsonProcessingException {
        return SpeedyQuery.toJsonNode(value, "$eq");
    }

    public static ObjectNode ne(@NotNull Object value) throws JsonProcessingException {
        return SpeedyQuery.toJsonNode(value, "$ne");
    }

    public static ObjectNode gt(@NotNull Object value) throws JsonProcessingException {
        return SpeedyQuery.toJsonNode(value, "$gt");
    }

    public static ObjectNode lt(@NotNull Object value) throws JsonProcessingException {
        return SpeedyQuery.toJsonNode(value, "$lt");
    }

    public static ObjectNode gte(@NotNull Object value) throws JsonProcessingException {
        return SpeedyQuery.toJsonNode(value, "$gte");
    }

    public static ObjectNode lte(@NotNull Object value) throws JsonProcessingException {
        return SpeedyQuery.toJsonNode(value, "$lte");
    }

    public static ObjectNode in(Object ... values) throws JsonProcessingException {
        return SpeedyQuery.toJsonNode(values, "$in");
    }

    public static ObjectNode nin(Object ... values) throws JsonProcessingException {
        return SpeedyQuery.toJsonNode(values, "$nin");
    }

    public static ObjectNode matches(@NotNull Object values) throws JsonProcessingException {
        return SpeedyQuery.toJsonNode(values, "$matches");
    }

    public static JsonNode condition(@NotNull String key, @NotNull JsonNode value) {
        ObjectNode jsonNodes = CommonUtil.json().createObjectNode();
        jsonNodes.set(key, value);
        return jsonNodes;
    }

    public static ObjectNode or(JsonNode ... conditions) {
        ObjectNode andNode = CommonUtil.json().createObjectNode();
        andNode.set("$or", (JsonNode)CommonUtil.json().createArrayNode());
        for (JsonNode condition : conditions) {
            ArrayNode and = (ArrayNode)andNode.get("$or");
            and.add(condition);
        }
        return andNode;
    }

    public static ObjectNode and(JsonNode ... conditions) {
        ObjectNode andNode = CommonUtil.json().createObjectNode();
        andNode.set("$and", (JsonNode)CommonUtil.json().createArrayNode());
        for (JsonNode condition : conditions) {
            ArrayNode and = (ArrayNode)andNode.get("$and");
            and.add(condition);
        }
        return andNode;
    }

    public SpeedyQuery fromEntity(@NotNull String from) {
        if (from == null || from.isEmpty()) {
            throw new IllegalArgumentException("The 'from' parameter cannot be null or empty.");
        }
        this.root.put("$from", from);
        return this;
    }

    public SpeedyQuery where(JsonNode ... conditionObjs) {
        for (JsonNode conditionObj : conditionObjs) {
            if (conditionObj == null || conditionObj.isEmpty()) {
                throw new IllegalArgumentException("The 'where' parameter cannot be null or empty.");
            }
            if (conditionObj.has("$and")) {
                this.where.removeAll();
                this.where.set("$and", conditionObj.get("$and"));
                break;
            }
            if (conditionObj.has("$or")) {
                this.where.removeAll();
                this.where.set("$or", conditionObj.get("$or"));
                break;
            }
            if (conditionObj.isEmpty()) continue;
            String firstField = (String)conditionObj.fieldNames().next();
            this.where.set(firstField, conditionObj.get(firstField));
        }
        return this;
    }

    public SpeedyQuery orderByAsc(@NotNull String key) {
        Objects.requireNonNull(key, "Key must not be null");
        this.orderBy.set(key, (JsonNode)new TextNode("ASC"));
        return this;
    }

    public SpeedyQuery orderByDesc(@NotNull String key) {
        this.orderBy.set(key, (JsonNode)new TextNode("DESC"));
        return this;
    }

    public SpeedyQuery expand(@NotNull String key) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Expand key cannot be null or empty.");
        }
        this.expand.add(key);
        return this;
    }

    public SpeedyQuery pageNo(@NotNull int pageNo) {
        if (pageNo < 0) {
            throw new IllegalArgumentException("Page number must not be less than 0.");
        }
        this.pageNo = pageNo;
        return this;
    }

    public SpeedyQuery pageSize(@NotNull int pageSize) {
        if (pageSize < 1) {
            throw new IllegalArgumentException("Page size must be greater than 0.");
        }
        this.pageSize = pageSize;
        return this;
    }

    public JsonNode build() {
        if (!this.where.isEmpty()) {
            this.root.set("$where", (JsonNode)this.where);
        }
        if (!this.orderBy.isEmpty()) {
            this.root.set("$orderBy", (JsonNode)this.orderBy);
        }
        if (!this.expand.isEmpty()) {
            this.root.set("$expand", (JsonNode)this.expand);
        }
        if (!this.select.isEmpty()) {
            ArrayNode arrayNode = CommonUtil.json().createArrayNode();
            this.select.forEach(arg_0 -> ((ArrayNode)arrayNode).add(arg_0));
            this.root.set("$select", (JsonNode)arrayNode);
        }
        ObjectNode pageNode = CommonUtil.json().createObjectNode();
        pageNode.put("$index", this.pageNo);
        pageNode.put("$size", this.pageSize);
        this.root.set("$page", (JsonNode)pageNode);
        return this.root;
    }

    public SpeedyQuery prettyPrint() throws JsonProcessingException {
        ObjectMapper json = CommonUtil.json();
        ObjectNode rootCopy = this.root.deepCopy();
        rootCopy.set("$where", (JsonNode)this.where);
        rootCopy.set("$orderBy", (JsonNode)this.orderBy);
        rootCopy.set("$expand", (JsonNode)this.expand);
        ObjectNode pageNode = json.createObjectNode();
        pageNode.put("$index", this.pageNo);
        pageNode.put("$size", this.pageSize);
        rootCopy.set("$page", (JsonNode)pageNode);
        String output = json.writerWithDefaultPrettyPrinter().writeValueAsString((Object)rootCopy);
        LOGGER.info("SpeedyQuery: {}", (Object)output);
        return this;
    }

    public String getFrom() {
        return this.root.get("$from").asText();
    }

    public SpeedyQuery select(String ... select) {
        this.select.addAll(Arrays.asList(select));
        return this;
    }
}

