/*
 * Decompiled with CFR 0.152.
 */
package com.github.silent.samurai.speedy.api.client.builder;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.silent.samurai.speedy.api.client.SpeedyApi;
import com.github.silent.samurai.speedy.api.client.models.SpeedyCreateRequest;
import com.github.silent.samurai.speedy.api.client.utils.JsonUtil;

public class SpeedyCreateRequestBuilder<T> {
    private final ObjectNode entity = JsonUtil.getObjectMapper().createObjectNode();
    private final String entityName;
    private final SpeedyApi<T> speedyApi;

    public SpeedyCreateRequestBuilder(String entityName, SpeedyApi<T> speedyApi) {
        this.entityName = entityName;
        this.speedyApi = speedyApi;
    }

    public <R> SpeedyCreateRequestBuilder<T> addField(String field, R value) {
        String[] parts = field.split("\\.");
        ObjectNode currentNode = this.entity;
        for (int i = 0; i < parts.length - 1; ++i) {
            String part = parts[i];
            if (!currentNode.has(part)) {
                currentNode.set(part, (JsonNode)JsonUtil.getObjectMapper().createObjectNode());
            }
            currentNode = (ObjectNode)currentNode.get(part);
        }
        currentNode.set(parts[parts.length - 1], (JsonNode)JsonUtil.getObjectMapper().convertValue(value, JsonNode.class));
        return this;
    }

    private SpeedyCreateRequest build() {
        SpeedyCreateRequest speedyCreateRequest = new SpeedyCreateRequest();
        speedyCreateRequest.setEntity(this.entityName);
        speedyCreateRequest.setBody((JsonNode)this.entity);
        return speedyCreateRequest;
    }

    public T execute() throws Exception {
        SpeedyCreateRequest request = this.build();
        return this.speedyApi.create(request);
    }

    public String getEntityName() {
        return this.entityName;
    }
}

