/*
 * Decompiled with CFR 0.152.
 */
package com.github.silent.samurai.speedy.api.client.builder;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.silent.samurai.speedy.api.client.SpeedyApi;
import com.github.silent.samurai.speedy.api.client.models.SpeedyDeleteRequest;
import com.github.silent.samurai.speedy.api.client.utils.JsonUtil;

public class SpeedyDeleteRequestBuilder<T> {
    private final ObjectNode pk = JsonUtil.getObjectMapper().createObjectNode();
    private final String entityName;
    private final SpeedyApi<T> speedyApi;

    public SpeedyDeleteRequestBuilder(String entityName, SpeedyApi<T> speedyApi) {
        this.entityName = entityName;
        this.speedyApi = speedyApi;
    }

    public SpeedyDeleteRequestBuilder<T> key(String field, Object value) {
        this.pk.set(field, (JsonNode)JsonUtil.getObjectMapper().convertValue(value, JsonNode.class));
        return this;
    }

    private SpeedyDeleteRequest build() {
        SpeedyDeleteRequest request = new SpeedyDeleteRequest();
        request.setEntity(this.entityName);
        ArrayNode arrayNode = JsonUtil.getObjectMapper().createArrayNode();
        arrayNode.add((JsonNode)this.pk);
        request.setPkToDelete(arrayNode);
        return request;
    }

    public T execute() throws Exception {
        SpeedyDeleteRequest request = this.build();
        return this.speedyApi.delete(request);
    }

    public String getEntityName() {
        return this.entityName;
    }
}

