/*
 * Decompiled with CFR 0.152.
 */
package com.github.silent.samurai.speedy.api.client.builder;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.silent.samurai.speedy.api.client.SpeedyApi;
import com.github.silent.samurai.speedy.api.client.models.SpeedyGetRequest;
import com.github.silent.samurai.speedy.api.client.utils.JsonUtil;

public class SpeedyGetRequestBuilder<T> {
    private final ObjectNode pk = JsonUtil.getObjectMapper().createObjectNode();
    private final String entityName;
    private final SpeedyApi<T> speedyApi;

    public SpeedyGetRequestBuilder(String entityName, SpeedyApi<T> speedyApi) {
        this.entityName = entityName;
        this.speedyApi = speedyApi;
    }

    public SpeedyGetRequestBuilder<T> key(String field, Object value) {
        this.pk.set(field, (JsonNode)JsonUtil.getObjectMapper().convertValue(value, JsonNode.class));
        return this;
    }

    private SpeedyGetRequest build() {
        SpeedyGetRequest request = new SpeedyGetRequest();
        request.setEntity(this.entityName);
        request.setPk(this.pk);
        return request;
    }

    public T execute() throws Exception {
        SpeedyGetRequest request = this.build();
        return this.speedyApi.get(request);
    }

    public String getEntityName() {
        return this.entityName;
    }
}

