/*
 * Decompiled with CFR 0.152.
 */
package com.github.silent.samurai.speedy.api.client.builder;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.silent.samurai.speedy.api.client.SpeedyApi;
import com.github.silent.samurai.speedy.api.client.models.SpeedyUpdateRequest;
import com.github.silent.samurai.speedy.api.client.utils.JsonUtil;

public class SpeedyUpdateRequestBuilder<T> {
    private final ObjectNode entity = JsonUtil.getObjectMapper().createObjectNode();
    private final String entityName;
    private final SpeedyApi<T> speedyApi;

    public SpeedyUpdateRequestBuilder(String entityName, SpeedyApi<T> speedyApi) {
        this.entityName = entityName;
        this.speedyApi = speedyApi;
    }

    public SpeedyUpdateRequestBuilder<T> key(String field, Object value) {
        this.entity.set(field, (JsonNode)JsonUtil.getObjectMapper().convertValue(value, JsonNode.class));
        return this;
    }

    public SpeedyUpdateRequestBuilder<T> field(String field, Object value) {
        this.entity.set(field, (JsonNode)JsonUtil.getObjectMapper().convertValue(value, JsonNode.class));
        return this;
    }

    public SpeedyUpdateRequest build() {
        SpeedyUpdateRequest request = new SpeedyUpdateRequest();
        request.setEntity(this.entityName);
        request.setBody((JsonNode)this.entity);
        return request;
    }

    public T execute() throws Exception {
        SpeedyUpdateRequest request = this.build();
        return this.speedyApi.update(request);
    }

    public String getEntityName() {
        return this.entityName;
    }
}

