/*
 * Decompiled with CFR 0.152.
 */
package com.github.silent.samurai.speedy.api.client.clients;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.silent.samurai.speedy.api.client.HttpClient;
import com.github.silent.samurai.speedy.api.client.models.SpeedyResponse;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class RestTemplateSpeedyClientImpl
implements HttpClient<SpeedyResponse> {
    private final RestTemplate restTemplate;
    private final String baseUrl;

    public RestTemplateSpeedyClientImpl(RestTemplate restTemplate, String baseUrl) {
        this.restTemplate = restTemplate;
        this.baseUrl = baseUrl;
    }

    @Override
    public SpeedyResponse invokeAPI(String path, HttpMethod method, MultiValueMap<String, String> queryParams, JsonNode body, HttpHeaders headerParams) throws Exception {
        String uri = UriComponentsBuilder.fromPath((String)path).queryParams(queryParams).build().toUriString();
        HttpEntity requestEntity = body != null ? new HttpEntity((Object)body.toString(), (MultiValueMap)headerParams) : new HttpEntity((MultiValueMap)headerParams);
        ResponseEntity response = this.restTemplate.exchange(uri, method, requestEntity, SpeedyResponse.class, new Object[0]);
        return (SpeedyResponse)response.getBody();
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }
}

