/*
 * Decompiled with CFR 0.152.
 */
package com.github.silent.samurai.speedy.api.client.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;

public class JsonUtil {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static ObjectMapper getObjectMapper() {
        return OBJECT_MAPPER;
    }

    public static String toJson(Object value) throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsString(value);
    }

    public static <T> T fromJson(JsonNode jsonNode, Class<T> type) throws JsonProcessingException {
        return (T)OBJECT_MAPPER.treeToValue((TreeNode)jsonNode, type);
    }

    public static <T> T fromJson(String json, Class<T> type) throws JsonProcessingException {
        return (T)OBJECT_MAPPER.readValue(json, type);
    }

    public static JsonNode parseJson(String json) throws JsonProcessingException {
        return OBJECT_MAPPER.readTree(json);
    }

    static {
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
        OBJECT_MAPPER.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        OBJECT_MAPPER.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_SINGLE_QUOTES});
    }
}

