/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallmenu.fun;

import com.github.smallmenu.fun.ArrayFun;

public final class DataSizeFun {
    public static final String[] DATASIZE_FORMAT = new String[]{"B", "KB", "MB", "GB", "TB", "PB"};
    public static final String B = "B";
    public static final String KB = "KB";
    public static final String MB = "MB";
    public static final String GB = "GB";
    public static final String TB = "TB";
    public static final String PB = "PB";
    public static final long BYTES_PER_KB = 1024L;
    public static final long BYTES_PER_MB = 0x100000L;
    public static final long BYTES_PER_GB = 0x40000000L;
    public static final long BYTES_PER_TB = 0x10000000000L;
    public static final long BYTES_PER_PB = 0x4000000000000L;

    private DataSizeFun() {
        throw new AssertionError();
    }

    public static String formatString(long bytes) {
        int index = 0;
        while (bytes >= 1024L) {
            bytes /= 1024L;
            ++index;
        }
        if (index < DATASIZE_FORMAT.length) {
            return bytes + DATASIZE_FORMAT[index];
        }
        return "";
    }

    public static String formatString(long bytes, String suffix) {
        if (ArrayFun.contains(DATASIZE_FORMAT, suffix)) {
            long size = DataSizeFun.format(bytes, suffix);
            return size + suffix;
        }
        return "";
    }

    public static long format(long bytes, String suffix) {
        if (bytes > 0L) {
            switch (suffix.toUpperCase()) {
                case "KB": {
                    return bytes / 1024L;
                }
                case "MB": {
                    return bytes / 0x100000L;
                }
                case "GB": {
                    return bytes / 0x40000000L;
                }
                case "TB": {
                    return bytes / 0x10000000000L;
                }
                case "PB": {
                    return bytes / 0x4000000000000L;
                }
            }
            return bytes;
        }
        return bytes;
    }
}

