/*
 * Decompiled with CFR 0.152.
 */
package org.sparta.springwebutils;

import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

public class SpringContextUtils {
    public static ApplicationContext contextMergedBeans(String xmlPath, Map<String, ?> extraBeans) {
        DefaultListableBeanFactory parentBeanFactory = SpringContextUtils.buildListableBeanFactory(extraBeans);
        GenericApplicationContext parentContext = new GenericApplicationContext(parentBeanFactory);
        XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)parentContext);
        xmlReader.loadBeanDefinitions(xmlPath);
        parentContext.refresh();
        return parentContext;
    }

    public static ApplicationContext contextMergedBeans(Map<String, ?> extraBeans, Class<?> config) {
        DefaultListableBeanFactory parentBeanFactory = SpringContextUtils.buildListableBeanFactory(extraBeans);
        GenericApplicationContext parentContext = new GenericApplicationContext(parentBeanFactory);
        AnnotatedBeanDefinitionReader annotationReader = new AnnotatedBeanDefinitionReader((BeanDefinitionRegistry)parentContext);
        annotationReader.registerBean(config);
        parentContext.refresh();
        return parentContext;
    }

    public static ApplicationContext contextMergedBeans(Map<String, ?> extraBeans, Class<?> config, Properties properties) {
        DefaultListableBeanFactory parentBeanFactory = SpringContextUtils.buildListableBeanFactory(extraBeans);
        GenericApplicationContext parentContext = new GenericApplicationContext(parentBeanFactory);
        SpringContextUtils.setProperties(parentContext, properties);
        AnnotatedBeanDefinitionReader annotationReader = new AnnotatedBeanDefinitionReader((BeanDefinitionRegistry)parentContext);
        annotationReader.registerBean(config);
        parentContext.refresh();
        return parentContext;
    }

    private static void setProperties(GenericApplicationContext newContext, Properties properties) {
        PropertiesPropertySource pps = new PropertiesPropertySource("external-props", properties);
        newContext.getEnvironment().getPropertySources().addFirst((PropertySource)pps);
    }

    private static DefaultListableBeanFactory buildListableBeanFactory(Map<String, ?> extraBeans) {
        DefaultListableBeanFactory parentBeanFactory = new DefaultListableBeanFactory();
        for (String key : extraBeans.keySet()) {
            parentBeanFactory.registerSingleton(key, extraBeans.get(key));
        }
        return parentBeanFactory;
    }
}

