/*
 * Decompiled with CFR 0.152.
 */
package org.sparta.springwebutils.util;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;

public abstract class StringUtility {
    public static void trimAllStringProperties(Object obj) throws Exception {
        PropertyDescriptor[] pds;
        if (obj == null) {
            return;
        }
        for (PropertyDescriptor pd : pds = Introspector.getBeanInfo(obj.getClass()).getPropertyDescriptors()) {
            if (!pd.getPropertyType().equals(String.class)) continue;
            Method readMethod = pd.getReadMethod();
            Method writeMethod = pd.getWriteMethod();
            if (readMethod == null || writeMethod == null) {
                throw new NoSuchMethodException("Getter/Setter for the property " + pd.getDisplayName() + " does not exist");
            }
            try {
                String val = (String)readMethod.invoke(obj, new Object[0]);
                writeMethod.invoke(obj, StringUtils.trim((String)val));
            }
            catch (IllegalAccessException e) {
                boolean isReadAccessible = readMethod.isAccessible();
                boolean isWriteAccessible = writeMethod.isAccessible();
                readMethod.setAccessible(true);
                writeMethod.setAccessible(true);
                String val = (String)readMethod.invoke(obj, new Object[0]);
                writeMethod.invoke(obj, StringUtils.trim((String)val));
                readMethod.setAccessible(isReadAccessible);
                writeMethod.setAccessible(isWriteAccessible);
            }
        }
    }
}

