package com.github.springbootPlus;

import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.myframework.JDBCCodeGenerator;
import org.myframework.codeutil.CodeGenerator;
import org.myframework.codeutil.TableMetaInfoReader;
import org.myframework.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.util.Properties;

/**
 * @className: ShowMeCodeMojo
 * @description:
 * @author: WANGHUI
 * @createDate: 2018/6/7 11:52
 * @version: 1.0
 * @goal showmecode
 */
public class ShowMeCodeMojo extends AbstractMojo {

        /**
     * Maven内置变量说明：
     * ${basedir} 项目根目录
     * ${project.build.directory} 构建目录，缺省为target
     * ${project.build.outputDirectory} 构建过程输出目录，缺省为target/classes
     * ${project.build.finalName} 产出物名称，缺省为${project.artifactId}-${project.version}
     * ${project.packaging} 打包类型，缺省为jar
     * ${project.xxx} 当前pom文件的任意节点的内容
     * Location of the file.
     *
     * @parameter expression="${basedir}"
     * @required
     */
    private File baseDirectory;
    private final static Logger logger = LoggerFactory.getLogger(JDBCCodeGenerator.class);


    String propertiesFile = "jdbc.properties";

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
       //1.工具类实例化
        String basedir =   baseDirectory+"/coderhelp/" ;
        FileUtil.createDir(basedir);
        TableMetaInfoReader tableMetaInfoReader = null;
        try {
            tableMetaInfoReader = new TableMetaInfoReader(basedir, propertiesFile);
            //代码内容--
            Properties properties = FileUtil.loadProperties(basedir + propertiesFile);
            String[] tableNames = StringUtils.split(properties.getProperty("tableName"), ",");
            for (String tableName : tableNames) {
                logger.debug("######## table {} code generate start   ##################" ,tableName);
                CodeGenerator code = new CodeGenerator();
                code.setTablePrefix(properties.getProperty("tablePrefix"));
                code.setPkgPrefix(properties.getProperty("pkgPrefix"));
                code.setModule(properties.getProperty("module"));
                code.setSubModule(properties.getProperty("subModule"));
                code.setTableName(tableName);
                //代码存放目录
                code.setJavaSource(properties.getProperty("javaSource"));
                code.setResources(properties.getProperty("resources"));
                code.setWebapp(properties.getProperty("webapp"));
                //配置信息存放路径
                code.setBasedir(basedir);
                code.setPropertiesFile(propertiesFile);
                code.initCodeTool(tableMetaInfoReader.getColumns(tableName));
                code.createCodeByConf();
                logger.debug("######## table {} code generate end   ##################" ,tableName);

            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }
}
