package org.myframework;

import org.apache.commons.lang.StringUtils;
import org.myframework.codeutil.CodeGenerator;
import org.myframework.codeutil.TableMetaInfoReader;
import org.myframework.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Properties;

public class JDBCCodeGenerator {
    private final static Logger logger = LoggerFactory.getLogger(JDBCCodeGenerator.class);

    /**
     * 代码生成工具调用
     *
     * @param args
     * @throws Exception
     */

    public static void main(String[] args) throws Exception {
        //1.工具类实例化
        String basedir = CodeGenerator.class.getClassLoader().getResource("").getPath();
        TableMetaInfoReader tableMetaInfoReader = new TableMetaInfoReader(basedir, "jdbc.properties");

        logger.info("读取数据库配置信息： ");
        //代码内容--
        String propertiesFile = "jdbc.properties";
        Properties properties = FileUtil.loadProperties(propertiesFile);
        String[] tableNames = StringUtils.split(properties.getProperty("tableName"), ",");

        for (String tableName : tableNames) {
            logger.debug("######## table {} code generate start   ##################", tableName);

            CodeGenerator code = new CodeGenerator();
            code.setTablePrefix(properties.getProperty("tablePrefix"));
            code.setPkgPrefix(properties.getProperty("pkgPrefix"));
            code.setModule(properties.getProperty("module"));
            code.setSubModule(properties.getProperty("subModule"));
            code.setTableName(tableName);
            //代码存放目录
            code.setJavaSource(properties.getProperty("javaSource"));
            code.setResources(properties.getProperty("resources"));
            code.setWebapp(properties.getProperty("webapp"));
            //配置信息存放路径
            code.setBasedir(basedir);
            code.setPropertiesFile(propertiesFile);

            code.initCodeTool(tableMetaInfoReader.getColumns(tableName));
            code.createCodeByConf();
            logger.debug("######## table {} code generate end   ##################", tableName);

        }

    }


}
