/*
 * Decompiled with CFR 0.152.
 */
package com.stuart.stuartclientjava.infrastructure;

import com.stuart.stuartclientjava.infrastructure.Environment;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.DefaultAccessTokenRequest;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsAccessTokenProvider;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsResourceDetails;
import org.springframework.security.oauth2.common.OAuth2AccessToken;

public class Authenticator {
    private final ClientCredentialsResourceDetails clientCredentialsResourceDetails;
    private final Environment environment;
    private OAuth2AccessToken oAuth2AccessToken;

    public Authenticator(Environment environment, String apiClientId, String apiClientSecret) {
        ClientCredentialsResourceDetails clientCredentialsResourceDetails = new ClientCredentialsResourceDetails();
        clientCredentialsResourceDetails.setAccessTokenUri(String.format("%s/oauth/token", environment.baseUrl()));
        clientCredentialsResourceDetails.setClientId(apiClientId);
        clientCredentialsResourceDetails.setClientSecret(apiClientSecret);
        this.clientCredentialsResourceDetails = clientCredentialsResourceDetails;
        this.environment = environment;
    }

    public String getAccessToken() {
        if (this.oAuth2AccessToken != null && !this.oAuth2AccessToken.isExpired()) {
            return this.oAuth2AccessToken.getValue();
        }
        this.oAuth2AccessToken = this.getNewAccessToken();
        return this.oAuth2AccessToken.getValue();
    }

    public OAuth2AccessToken getNewAccessToken() {
        return new ClientCredentialsAccessTokenProvider().obtainAccessToken((OAuth2ProtectedResourceDetails)this.clientCredentialsResourceDetails, (AccessTokenRequest)new DefaultAccessTokenRequest());
    }

    public Environment getEnvironment() {
        return this.environment;
    }
}

