/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.Friend;
import com.skype.Skype;
import com.skype.SkypeException;
import com.skype.SkypeObject;
import com.skype.Utils;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import java.util.HashMap;
import java.util.Map;

public final class Group
extends SkypeObject {
    private static final Map<String, Group> groups = new HashMap<String, Group>();
    private String id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Group getInstance(String id) {
        Map<String, Group> map = groups;
        synchronized (map) {
            if (!groups.containsKey(id)) {
                groups.put(id, new Group(id));
            }
            return groups.get(id);
        }
    }

    private Group(String newId) {
        this.id = newId;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object compared) {
        if (this == compared) {
            return true;
        }
        if (compared instanceof Group) {
            return this.getId().equals(((Group)compared).getId());
        }
        return false;
    }

    public String toString() {
        return this.getId();
    }

    public String getId() {
        return this.id;
    }

    public void addFriend(Friend friend) throws SkypeException {
        Utils.executeWithErrorCheck("ALTER GROUP " + this.getId() + " ADDUSER " + friend.getId());
    }

    public void addPSTN(String pstn) throws SkypeException {
        Utils.executeWithErrorCheck("ALTER GROUP " + this.getId() + " ADDUSER " + pstn);
    }

    public void removeFriend(Friend friend) throws SkypeException {
        Utils.executeWithErrorCheck("ALTER GROUP " + this.getId() + " REMOVEUSER " + friend.getId());
    }

    public void removePSTN(String pstn) throws SkypeException {
        Utils.executeWithErrorCheck("ALTER GROUP " + this.getId() + " REMOVEUSER " + pstn);
    }

    public void changeFriendDisplayName(Friend friend, String displayName) throws SkypeException {
        friend.setDisplayName(displayName);
    }

    public void changePSTNDisplayName(String pstn, String displayName) throws SkypeException {
        Utils.executeWithErrorCheck("SET USER " + pstn + " DISPLAYNAME " + displayName);
    }

    public Friend[] getAllFriends() throws SkypeException {
        String[] ids = Utils.convertToArray(this.getProperty("USERS"));
        Friend[] friends = new Friend[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            friends[i] = Skype.getContactList().getFriend(ids[i]);
        }
        return friends;
    }

    public boolean hasFriend(Friend checked) throws SkypeException {
        for (Friend friend : this.getAllFriends()) {
            if (!checked.equals(friend)) continue;
            return true;
        }
        return false;
    }

    public boolean isVisible() throws SkypeException {
        return Boolean.parseBoolean(this.getProperty("VISIBLE"));
    }

    public boolean isExpanded() throws SkypeException {
        return Boolean.parseBoolean(this.getProperty("EXPANDED"));
    }

    public String getDisplayName() throws SkypeException {
        return this.getProperty("DISPLAYNAME");
    }

    public void setDisplayName(String newValue) throws SkypeException {
        this.setProperty("DISPLAYNAME", newValue);
    }

    public Type getType() throws SkypeException {
        return Type.valueOf(this.getProperty("TYPE"));
    }

    private String getProperty(String name) throws SkypeException {
        return Utils.getProperty("GROUP", this.getId(), name);
    }

    private void setProperty(String name, String newValue) throws SkypeException {
        Utils.setProperty("GROUP", this.getId(), name, newValue);
    }

    public void dispose() throws SkypeException {
        try {
            String response = Connector.getInstance().execute("DELETE GROUP " + this.getId(), "DELETED GROUP ");
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    public static enum Type {
        ALL_USERS,
        ALL_FRIENDS,
        SKYPE_FRIENDS,
        SKYPEOUT_FRIENDS,
        ONLINE_FRIENDS,
        UNKNOWN_OR_PENDINGAUTH_FRIENDS,
        RECENTLY_CONTACTED_USERS,
        USERS_WAITING_MY_AUTHORIZATION,
        USERS_AUTHORIZED_BY_ME,
        USERS_BLOCKED_BY_ME,
        UNGROUPED_FRIENDS,
        CUSTOM_GROUP,
        SHARED_GROUP,
        PROPOSED_SHARED_GROUP;

    }
}

