/*
 * Decompiled with CFR 0.152.
 */
package com.skype.connector.osx;

import com.skype.connector.ConnectorUtils;
import com.skype.connector.LoadLibraryException;
import com.skype.connector.osx.SkypeFrameworkListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

final class SkypeFramework {
    private static Object initializedFieldMutex = new Object();
    private static boolean initialized = false;
    private static final List<SkypeFrameworkListener> listeners = new CopyOnWriteArrayList<SkypeFrameworkListener>();
    private static Object sendCommandMutex = new Object();
    private static Object notificationReceivedMutex = new Object();

    SkypeFramework() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void init(String applicationName) throws LoadLibraryException {
        ConnectorUtils.checkNotNull("applicationName", applicationName);
        Object object = initializedFieldMutex;
        synchronized (object) {
            if (!initialized) {
                ConnectorUtils.loadLibrary("skype");
                SkypeFramework.setup0(applicationName);
                initialized = true;
            }
        }
    }

    private static native void setup0(String var0);

    static void addSkypeFrameworkListener(SkypeFrameworkListener listener) {
        listeners.add(listener);
    }

    static void removeSkypeFrameworkListener(SkypeFrameworkListener listener) {
        listeners.remove(listener);
    }

    static boolean isRunning() {
        return SkypeFramework.isRunning0();
    }

    private static native boolean isRunning0();

    static boolean isAvailable() {
        return SkypeFramework.isAvailable0();
    }

    private static native boolean isAvailable0();

    static void fireBecameAvailable() {
        for (SkypeFrameworkListener listener : listeners) {
            listener.becameAvailable();
        }
    }

    static void fireBecameUnavailable() {
        for (SkypeFrameworkListener listener : listeners) {
            listener.becameUnavailable();
        }
    }

    static void connect() {
        SkypeFramework.connect0();
    }

    private static native void connect0();

    static void fireAttachResponse(int attachResponseCode) {
        for (SkypeFrameworkListener listener : listeners) {
            listener.attachResponse(attachResponseCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String sendCommand(String commandString) {
        Object object = sendCommandMutex;
        synchronized (object) {
            return SkypeFramework.sendCommand0(commandString);
        }
    }

    private static native String sendCommand0(String var0);

    static void fireNotificationReceived(String notificationString) {
        for (SkypeFrameworkListener listener : listeners) {
            listener.notificationReceived(notificationString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void dispose() {
        Object object = initializedFieldMutex;
        synchronized (object) {
            if (initialized) {
                SkypeFramework.dispose0();
                listeners.clear();
                initialized = false;
            }
        }
    }

    private static native void dispose0();

    static int runCurrentEventLoop(double inTimeout) {
        return SkypeFramework.runCurrentEventLoop0(inTimeout);
    }

    private static native int runCurrentEventLoop0(double var0);

    static void runApplicationEventLoop() {
        SkypeFramework.runApplicationEventLoop0();
    }

    private static native void runApplicationEventLoop0();

    static void quitApplicationEventLoop() {
        SkypeFramework.quitApplicationEventLoop0();
    }

    private static native void quitApplicationEventLoop0();
}

