/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.ChatListener;
import com.skype.ChatMessage;
import com.skype.GlobalChatListener;
import com.skype.Skype;
import com.skype.SkypeException;
import com.skype.SkypeObject;
import com.skype.User;
import com.skype.Utils;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Chat
extends SkypeObject {
    private static final Map<String, Chat> chats = new HashMap<String, Chat>();
    private final String id;
    List<ChatListener> instanceChatListeners = new ArrayList<ChatListener>();
    private GlobalChatListener localListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Chat getInstance(String id) {
        Map<String, Chat> map = chats;
        synchronized (map) {
            if (!chats.containsKey(id)) {
                Chat chat = new Chat(id);
                chats.put(id, chat);
            }
            return chats.get(id);
        }
    }

    private Chat(String newId) {
        assert (newId != null);
        this.id = newId;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object compared) {
        if (compared instanceof Chat) {
            return this.getId().equals(((Chat)compared).getId());
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public void setTopic(String newValue) throws SkypeException {
        try {
            String command = "ALTER CHAT " + this.getId() + " SETTOPIC " + newValue;
            String responseHeader = "ALTER CHAT SETTOPIC";
            String response = Connector.getInstance().execute(command, responseHeader);
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    public void setGuidelines(String newValue) throws SkypeException {
        try {
            String command = "ALTER CHAT " + this.getId() + " SETGUIDELINES " + newValue;
            String responseHeader = "ALTER CHAT SETGUIDELINES";
            String response = Connector.getInstance().execute(command, responseHeader);
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    public void addUser(User addedUser) throws SkypeException {
        Utils.checkNotNull("addedUser", addedUser);
        this.addUsers(new User[]{addedUser});
    }

    public void addUsers(User[] addedUsers) throws SkypeException {
        Utils.checkNotNull("addedUsers", addedUsers);
        try {
            String command = "ALTER CHAT " + this.getId() + " ADDMEMBERS " + Chat.toCommaSeparatedString(addedUsers);
            String responseHeader = "ALTER CHAT ADDMEMBERS";
            String response = Connector.getInstance().execute(command, responseHeader);
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    public void leave() throws SkypeException {
        try {
            String command = "ALTER CHAT " + this.getId() + " LEAVE";
            String responseHeader = "ALTER CHAT LEAVE";
            String response = Connector.getInstance().execute(command, responseHeader);
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    public ChatMessage[] getAllChatMessages() throws SkypeException {
        try {
            String command = "GET CHAT " + this.getId() + " CHATMESSAGES";
            String responseHeader = "CHAT " + this.getId() + " CHATMESSAGES ";
            String response = Connector.getInstance().execute(command, responseHeader);
            if (response.contains("ERROR")) {
                throw new SkypeException("Error when issuing command: " + command + " - " + response);
            }
            String data = response.substring(responseHeader.length());
            String[] ids = Utils.convertToArray(data);
            ChatMessage[] chatMessages = new ChatMessage[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                chatMessages[i] = ChatMessage.getInstance(ids[i]);
            }
            return chatMessages;
        }
        catch (ConnectorException ex) {
            Utils.convertToSkypeException(ex);
            return null;
        }
    }

    public ChatMessage[] getRecentChatMessages() throws SkypeException {
        try {
            String command = "GET CHAT " + this.getId() + " RECENTCHATMESSAGES";
            String responseHeader = "CHAT " + this.getId() + " RECENTCHATMESSAGES ";
            String response = Connector.getInstance().execute(command, responseHeader);
            String data = response.substring(responseHeader.length());
            String[] ids = Utils.convertToArray(data);
            ChatMessage[] chatMessages = new ChatMessage[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                chatMessages[i] = ChatMessage.getInstance(ids[i]);
            }
            return chatMessages;
        }
        catch (ConnectorException ex) {
            Utils.convertToSkypeException(ex);
            return null;
        }
    }

    public ChatMessage send(String message) throws SkypeException {
        try {
            String responseHeader = "CHATMESSAGE ";
            String response = Connector.getInstance().executeWithId("CHATMESSAGE " + this.getId() + " " + message, responseHeader);
            Utils.checkError(response);
            String msgId = response.substring(responseHeader.length(), response.indexOf(" STATUS "));
            return ChatMessage.getInstance(msgId);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    public Date getTime() throws SkypeException {
        return Utils.parseUnixTime(this.getProperty("TIMESTAMP"));
    }

    public User getAdder() throws SkypeException {
        String adder = this.getProperty("ADDER");
        if ("".equals(adder)) {
            return null;
        }
        return User.getInstance(adder);
    }

    public Status getStatus() throws SkypeException {
        return Status.valueOf(Utils.getPropertyWithCommandId("CHAT", this.getId(), "STATUS"));
    }

    public String getWindowTitle() throws SkypeException {
        return this.getProperty("FRIENDLYNAME");
    }

    public User[] getAllPosters() throws SkypeException {
        return this.getUsersProperty("POSTERS");
    }

    public User[] getAllMembers() throws SkypeException {
        return this.getUsersProperty("MEMBERS");
    }

    public User[] getAllActiveMembers() throws SkypeException {
        return this.getUsersProperty("ACTIVEMEMBERS");
    }

    public boolean isBookmarked() throws SkypeException {
        return Boolean.parseBoolean(this.getProperty("BOOKMARKED"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ChatListener listener) throws SkypeException {
        if (this.localListener == null) {
            this.createInstanceChatListenerDelegator();
        }
        List<ChatListener> list = this.instanceChatListeners;
        synchronized (list) {
            this.instanceChatListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ChatListener listener) {
        List<ChatListener> list = this.instanceChatListeners;
        synchronized (list) {
            this.instanceChatListeners.remove(listener);
        }
    }

    private void createInstanceChatListenerDelegator() throws SkypeException {
        this.localListener = new ChatInstanceListener();
        Skype.addGlobalChatListener(this.localListener, this);
    }

    private static String toCommaSeparatedString(User[] users) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < users.length; ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            builder.append(users[i].getId());
        }
        return builder.toString();
    }

    private User[] getUsersProperty(String name) throws SkypeException {
        try {
            String command = "GET CHAT " + this.getId() + " " + name;
            String responseHeader = "CHAT " + this.id + " " + name + " ";
            String response = Connector.getInstance().execute(command, responseHeader);
            String data = response.substring(responseHeader.length());
            if ("".equals(data)) {
                return new User[0];
            }
            String[] ids = data.split(" ");
            User[] users = new User[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                users[i] = User.getInstance(ids[i]);
            }
            return users;
        }
        catch (ConnectorException ex) {
            Utils.convertToSkypeException(ex);
            return null;
        }
    }

    private String getProperty(String name) throws SkypeException {
        return Utils.getProperty("CHAT", this.getId(), name);
    }

    public static enum Status {
        DIALOG,
        LEGACY_DIALOG,
        MULTI_SUBSCRIBED,
        UNSUBSCRIBED;

    }

    private final class ChatInstanceListener
    implements GlobalChatListener {
        private ChatInstanceListener() {
        }

        @Override
        public void userLeft(Chat chat, User user) {
            if (chat.equals(Chat.this)) {
                for (ChatListener listener : Chat.this.instanceChatListeners) {
                    listener.userLeft(user);
                }
            }
        }

        @Override
        public void userAdded(Chat chat, User user) {
            if (chat.equals(Chat.this)) {
                for (ChatListener listener : Chat.this.instanceChatListeners) {
                    listener.userAdded(user);
                }
            }
        }

        @Override
        public void newChatStarted(Chat chat, User[] users) {
        }
    }
}

