/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.ChatMessage;
import com.skype.ChatMessageListener;
import com.skype.Skype;
import com.skype.connector.AbstractConnectorListener;
import com.skype.connector.ConnectorMessageEvent;

final class ChatMessageConnectorListener
extends AbstractConnectorListener {
    private static final String CHATMESSAGE_API_MSG = "CHATMESSAGE ";
    private static final String READ_MESSAGE_SUFFIX = "READ";
    private static final String RECEIVED_MESSAGE_SUFFIX = "RECEIVED";
    private static final String SENT_MESSAGE_SUFFIX = "SENT";
    String lastReceivedId = "";
    private String lastReceivedReadId = "";

    ChatMessageConnectorListener() {
    }

    @Override
    public void messageReceived(ConnectorMessageEvent event) {
        String message = event.getMessage();
        if (message.startsWith(CHATMESSAGE_API_MSG)) {
            String data = message.substring(CHATMESSAGE_API_MSG.length());
            String id = data.substring(0, data.indexOf(32));
            String propertyNameAndValue = data.substring(data.indexOf(32) + 1);
            String propertyName = propertyNameAndValue.substring(0, propertyNameAndValue.indexOf(32));
            if ("STATUS".equals(propertyName)) {
                String propertyValue = propertyNameAndValue.substring(propertyNameAndValue.indexOf(32) + 1);
                ChatMessageListener[] listeners = Skype.chatMessageListeners.toArray(new ChatMessageListener[0]);
                ChatMessage chatMessage = ChatMessage.getInstance(id);
                if (SENT_MESSAGE_SUFFIX.equals(propertyValue)) {
                    this.fireMessageSent(listeners, chatMessage);
                } else if (RECEIVED_MESSAGE_SUFFIX.equals(propertyValue)) {
                    if (this.lastReceivedReadId.equals(chatMessage.getId())) {
                        return;
                    }
                    this.fireMessageReceived(listeners, chatMessage);
                    this.lastReceivedId = chatMessage.getId();
                } else if (READ_MESSAGE_SUFFIX.equals(propertyValue)) {
                    if (this.lastReceivedId.equals(chatMessage.getId())) {
                        return;
                    }
                    this.fireMessageReceived(listeners, chatMessage);
                    this.lastReceivedReadId = chatMessage.getId();
                }
            }
        }
    }

    private void fireMessageSent(ChatMessageListener[] listeners, ChatMessage chatMessage) {
        for (ChatMessageListener listener : listeners) {
            try {
                listener.chatMessageSent(chatMessage);
            }
            catch (Throwable e) {
                Skype.handleUncaughtException(e);
            }
        }
    }

    private void fireMessageReceived(ChatMessageListener[] listeners, ChatMessage chatMessage) {
        for (ChatMessageListener listener : listeners) {
            try {
                listener.chatMessageReceived(chatMessage);
            }
            catch (Throwable e) {
                Skype.handleUncaughtException(e);
            }
        }
    }
}

