/*
 * Decompiled with CFR 0.152.
 */
package testoptimal.api;

import com.google.gson.Gson;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import testoptimal.api.APIError;
import testoptimal.api.Constants;
import testoptimal.api.FSM.AgentCmdResult;
import testoptimal.api.FSM.ModelRequest;
import testoptimal.api.FSM.Trans;
import testoptimal.api.RunResult;
import testoptimal.api.Server;

public class AgentAPI {
    private Server svr;
    private Gson gson = new Gson();
    private String agentID;
    private MbtSessInfo mbtSessInfo;
    private ModelRequest runReq;

    protected AgentAPI(Server svr_p) {
        this.svr = svr_p;
    }

    public String getAgentID() {
        return this.agentID;
    }

    public String execModel(String modelName_p) throws APIError {
        return this.execModel(modelName_p, Constants.MbtMode.Optimal);
    }

    public String execModel(String modelName_p, Constants.MbtMode mbtMode_p) throws APIError {
        this.runReq = new ModelRequest();
        this.runReq.options.put("path", "client");
        this.runReq.modelName = modelName_p;
        this.runReq.mbtMode = mbtMode_p.name();
        this.runReq.options.put("autoClose", false);
        String reqJson = this.gson.toJson((Object)this.runReq);
        this.mbtSessInfo = null;
        this.agentID = null;
        this.mbtSessInfo = (MbtSessInfo)this.gson.fromJson(this.svr.sendPost("runtime", "model/run/async", reqJson, 200), MbtSessInfo.class);
        return this.mbtSessInfo.mbtSessID;
    }

    public String execModel(String modelName_p, List<Trans> transList_p, boolean optimal_p) throws APIError {
        this.runReq = new ModelRequest();
        this.runReq.options.put("path", "client");
        this.runReq.modelName = modelName_p;
        this.runReq.mbtMode = optimal_p ? "MarkedOptimal" : "MarkedSerial";
        List transUIDs = transList_p.stream().map(t -> t.getUid()).collect(Collectors.toList());
        this.runReq.options.put("markList", transUIDs);
        this.runReq.options.put("autoClose", false);
        String reqJson = this.gson.toJson((Object)this.runReq);
        this.mbtSessInfo = null;
        this.agentID = null;
        this.mbtSessInfo = (MbtSessInfo)this.gson.fromJson(this.svr.sendPost("runtime", "model/run/async", reqJson, 200), MbtSessInfo.class);
        return this.mbtSessInfo.mbtSessID;
    }

    public String regAgent(String modelName_p) throws APIError {
        this.agentID = UUID.randomUUID().toString().replace("-", "");
        this.svr.sendGet("agent", "register/" + this.runReq.modelName + "/" + this.agentID, null, 200);
        return this.agentID;
    }

    public String getNextCmd() throws APIError {
        return this.getNextCmd(0L);
    }

    public String getNextCmd(long timeoutMillis_p) throws APIError {
        this.checkModelRunning("nextCmd");
        String resultJson = this.svr.sendGet("agent", "nextCmd/" + this.agentID + (timeoutMillis_p > 0L ? "?timeoutMillis=" + timeoutMillis_p : ""), null, 200);
        if (resultJson.contentEquals("")) {
            return null;
        }
        RemoteCmd cmd = (RemoteCmd)this.gson.fromJson(resultJson, RemoteCmd.class);
        return cmd.cmd == null || cmd.cmd.equals("") ? null : cmd.cmd;
    }

    public String setResult(boolean isSuccess_p, String result_p) throws APIError {
        return this.setResult(isSuccess_p, result_p, null, null, null);
    }

    public String setResult(boolean isSuccess_p, String result_p, String reqTag_p) throws APIError {
        return this.setResult(isSuccess_p, result_p, reqTag_p, null, null);
    }

    public String setResult(boolean isSuccess_p, String result_p, String reqTag_p, String assertID_p) throws APIError {
        return this.setResult(isSuccess_p, result_p, reqTag_p, assertID_p, null);
    }

    public String setResult(boolean isSuccess_p, String result_p, String reqTag_p, String assertID_p, Map<String, Object> moreAttrs_p) throws APIError {
        this.checkModelRunning("setResult");
        AgentCmdResult rslt = new AgentCmdResult();
        rslt.status = isSuccess_p;
        rslt.result = result_p;
        rslt.assertID = assertID_p;
        rslt.reqTag = reqTag_p;
        rslt.moreAttrs = moreAttrs_p;
        String rsltJson = this.gson.toJson((Object)rslt);
        return this.svr.sendPost("agent", "setResult/" + this.agentID, rsltJson, 200);
    }

    public void stopModelExec() throws APIError {
        this.checkModelRunning("stopModel");
        this.svr.sendGet("runtime", "session/" + this.mbtSessInfo.mbtSessID + "/stop", null, 200);
    }

    public void closeModel(String modelName_p) throws APIError {
        this.svr.sendGet("model", modelName_p + "/close", null, 200);
        this.mbtSessInfo = null;
        this.agentID = null;
    }

    public RunResult getModelStats(String modelName_p) throws APIError {
        String retJson = this.svr.sendGet("client", "model/" + modelName_p, null, 200);
        RunResult result = (RunResult)this.gson.fromJson(retJson, RunResult.class);
        return result;
    }

    protected void modelClosed() {
        this.mbtSessInfo = null;
        this.agentID = null;
    }

    private void checkModelRunning(String path_p) throws APIError {
        if (this.mbtSessInfo == null) {
            throw new APIError(-1, "api", "model not running", path_p);
        }
    }

    private class RemoteCmd {
        String cmd;

        private RemoteCmd() {
        }
    }

    public class MbtSessInfo {
        public String statsURL;
        public String mbtSessID;
        public String status;
    }
}

