/*
 * Decompiled with CFR 0.152.
 */
package com.github.triceo.splitlog.api;

import com.github.triceo.splitlog.api.Follower;
import com.github.triceo.splitlog.api.LogWatch;
import com.github.triceo.splitlog.api.SimpleMessageCondition;
import com.github.triceo.splitlog.api.TailSplitter;
import java.io.File;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;

public abstract class LogWatchBuilder {
    public static final long DEFAULT_DELAY_BETWEEN_READS_IN_MILLISECONDS = 1000L;
    public static final long DEFAULT_DELAY_BETWEEN_SWEEPS_IN_MILLISECONDS = 60000L;
    public static final int DEFAULT_READ_BUFFER_SIZE_IN_BYTES = 4096;
    private boolean autoStarting = true;
    private int bufferSize = 4096;
    private boolean closingBetweenReads;
    private long delayBetweenReads = 1000L;
    private long delayBetweenSweeps = 60000L;
    private File fileToWatch;
    private SimpleMessageCondition gateCondition;
    private int limitCapacityTo = Integer.MAX_VALUE;
    private boolean readingFromBeginning = true;
    private SimpleMessageCondition storageCondition;

    public static LogWatchBuilder getDefault() {
        ServiceLoader<LogWatchBuilder> ldr = ServiceLoader.load(LogWatchBuilder.class);
        if (!ldr.iterator().hasNext()) {
            throw new IllegalStateException("No LogWatchBuilder implementation registered.");
        }
        return ldr.iterator().next();
    }

    private static long getDelay(int length, TimeUnit unit) {
        if (length < 1) {
            throw new IllegalArgumentException("The length of time must be at least 1.");
        }
        switch (unit) {
            case NANOSECONDS: {
                if (length >= 1000000) break;
                throw new IllegalArgumentException("The length of time must amount to at least 1 ms.");
            }
            case MICROSECONDS: {
                if (length >= 1000) break;
                throw new IllegalArgumentException("The length of time must amount to at least 1 ms.");
            }
        }
        return unit.toMillis(length);
    }

    public abstract LogWatch build();

    public abstract Follower buildFollowing();

    public abstract Follower buildFollowingWith(TailSplitter var1);

    public abstract LogWatch buildWith(TailSplitter var1);

    public LogWatchBuilder closingAfterReading() {
        this.closingBetweenReads = true;
        return this;
    }

    public LogWatchBuilder doNotStart() {
        this.autoStarting = false;
        return this;
    }

    public int getCapacityLimit() {
        return this.limitCapacityTo;
    }

    public long getDelayBetweenReads() {
        return this.delayBetweenReads;
    }

    public long getDelayBetweenSweeps() {
        return this.delayBetweenSweeps;
    }

    public File getFileToWatch() {
        return this.fileToWatch;
    }

    public SimpleMessageCondition getGateCondition() {
        return this.gateCondition;
    }

    public int getReadingBufferSize() {
        return this.bufferSize;
    }

    public SimpleMessageCondition getStorageCondition() {
        return this.storageCondition;
    }

    public LogWatchBuilder ignoringPreexistingContent() {
        this.readingFromBeginning = false;
        return this;
    }

    public boolean isClosingBetweenReads() {
        return this.closingBetweenReads;
    }

    public boolean isReadingFromBeginning() {
        return this.readingFromBeginning;
    }

    public LogWatchBuilder limitCapacityTo(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size of the memory store must be larger than zero.");
        }
        this.limitCapacityTo = size;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LogWatchBuilder [bufferSize=").append(this.bufferSize).append(", closingBetweenReads=").append(this.closingBetweenReads).append(", delayBetweenReads=").append(this.delayBetweenReads).append(", delayBetweenSweeps=").append(this.delayBetweenSweeps).append(", ");
        if (this.fileToWatch != null) {
            builder.append("fileToWatch=").append(this.fileToWatch).append(", ");
        }
        if (this.gateCondition != null) {
            builder.append("gateCondition=").append(this.gateCondition).append(", ");
        }
        builder.append("limitCapacityTo=").append(this.limitCapacityTo).append(", readingFromBeginning=").append(this.readingFromBeginning).append(", ");
        if (this.storageCondition != null) {
            builder.append("storageCondition=").append(this.storageCondition);
        }
        builder.append("]");
        return builder.toString();
    }

    public LogWatchBuilder watchedFile(File f) {
        if (f == null) {
            throw new IllegalArgumentException("File can not be null.");
        }
        this.fileToWatch = f;
        return this;
    }

    @Deprecated
    public LogWatchBuilder watchingFile(File f) {
        return this.watchedFile(f);
    }

    public boolean willBeStarted() {
        return this.autoStarting;
    }

    public LogWatchBuilder withDelayBetweenReads(int length, TimeUnit unit) {
        this.delayBetweenReads = LogWatchBuilder.getDelay(length, unit);
        return this;
    }

    public LogWatchBuilder withDelayBetweenSweeps(int length, TimeUnit unit) {
        this.delayBetweenSweeps = LogWatchBuilder.getDelay(length, unit);
        return this;
    }

    public LogWatchBuilder withGateCondition(SimpleMessageCondition condition) {
        if (condition == null) {
            throw new IllegalArgumentException("Gate condition must not be null.");
        }
        this.gateCondition = condition;
        return this;
    }

    public LogWatchBuilder withReadingBufferSize(int bufferSize) {
        if (bufferSize < 1) {
            throw new IllegalArgumentException("Buffer size must be at least 1.");
        }
        this.bufferSize = bufferSize;
        return this;
    }

    public LogWatchBuilder withStorageCondition(SimpleMessageCondition condition) {
        if (condition == null) {
            throw new IllegalArgumentException("Storage acceptance condition must not be null.");
        }
        this.storageCondition = condition;
        return this;
    }
}

