/*
 * Decompiled with CFR 0.152.
 */
package com.github.triceo.splitlog.logging;

import com.github.triceo.splitlog.logging.SplitlogLoggerInvocationHandler;
import com.github.triceo.splitlog.logging.SplitlogLoggingState;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SplitlogLoggerFactory {
    public static final String LOGGING_PROPERTY_NAME = "splitlog.logging";
    private static final AtomicLong messageCounter = new AtomicLong(0L);
    public static final String OFF_STATE = "off";
    public static final String ON_STATE = "on";
    private static SplitlogLoggingState state = SplitlogLoggingState.DEFAULT;

    public static synchronized void enableLogging() {
        if (state == SplitlogLoggingState.ON) {
            return;
        }
        messageCounter.set(0L);
        state = SplitlogLoggingState.ON;
        LoggerFactory.getLogger(SplitlogLoggerFactory.class).info("Forcibly enabled Splitlog's internal logging.");
    }

    public static Logger getLogger(Class<?> cls) {
        return (Logger)Proxy.newProxyInstance(Logger.class.getClassLoader(), new Class[]{Logger.class}, (InvocationHandler)new SplitlogLoggerInvocationHandler(LoggerFactory.getLogger(cls)));
    }

    public static Logger getLogger(String cls) {
        return (Logger)Proxy.newProxyInstance(Logger.class.getClassLoader(), new Class[]{Logger.class}, (InvocationHandler)new SplitlogLoggerInvocationHandler(LoggerFactory.getLogger((String)cls)));
    }

    static long getMessagesSinceLastStateChange() {
        return messageCounter.get();
    }

    static void increaseMessageCounter() {
        messageCounter.incrementAndGet();
    }

    public static synchronized boolean isLoggingEnabled() {
        switch (state) {
            case ON: {
                return true;
            }
            case OFF: {
                return false;
            }
        }
        String propertyValue = System.getProperty(LOGGING_PROPERTY_NAME, OFF_STATE);
        return propertyValue.equals(ON_STATE);
    }

    public static synchronized void resetLoggingToDefaultState() {
        SplitlogLoggingState previousState = state;
        if (previousState == SplitlogLoggingState.DEFAULT) {
            return;
        }
        LoggerFactory.getLogger(SplitlogLoggerFactory.class).info("Splitlog's internal logging reset back to property-driven.");
        state = SplitlogLoggingState.DEFAULT;
        messageCounter.set(0L);
    }

    public static synchronized void silenceLogging() {
        if (state == SplitlogLoggingState.OFF) {
            return;
        }
        state = SplitlogLoggingState.OFF;
        messageCounter.set(0L);
        LoggerFactory.getLogger(SplitlogLoggerFactory.class).info("Forcibly disabled Splitlog's internal logging.");
    }

    static {
        Logger l = LoggerFactory.getLogger(SplitlogLoggerFactory.class);
        if (SplitlogLoggerFactory.isLoggingEnabled()) {
            l.info("Splitlog's internal logging system can be disabled by setting '{}' system property to '{}'.", (Object)LOGGING_PROPERTY_NAME, (Object)OFF_STATE);
        } else {
            l.warn("This will be the last message from Splitlog, unless you enable Splitlog's internal logging system by setting '{}' system property to '{}'.", (Object)LOGGING_PROPERTY_NAME, (Object)ON_STATE);
        }
    }
}

