/*
 * Decompiled with CFR 0.152.
 */
package com.github.vatbub.commandlineUserPromptProcessor;

import com.github.vatbub.commandlineUserPromptProcessor.parsables.Parsable;
import com.github.vatbub.commandlineUserPromptProcessor.parsables.ParseException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Scanner;

public class Prompt {
    private String promptText;
    private Parsable returnValue;

    public Prompt(String promptText, Parsable returnValue) {
        this.setPromptText(promptText);
        this.setReturnValue(returnValue);
    }

    public String getPromptText() {
        return this.promptText;
    }

    public void setPromptText(String promptText) {
        this.promptText = promptText;
    }

    public Parsable getReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(Parsable returnValue) {
        this.returnValue = returnValue;
    }

    public Parsable doPrompt() throws ParseException {
        return this.doPrompt(System.out, System.in);
    }

    public Parsable doPrompt(PrintStream out, InputStream in) throws ParseException {
        StringBuilder finalPromptText = new StringBuilder(this.getPromptText());
        String optionsString = this.getReturnValue().getOptionsString();
        String defaultValue = this.getReturnValue().getStringForDefaultValue();
        if (optionsString != null) {
            finalPromptText.append(" [");
            finalPromptText.append(optionsString);
            finalPromptText.append("]");
        }
        if (defaultValue != null) {
            finalPromptText.append(" [default: ");
            finalPromptText.append(defaultValue);
            finalPromptText.append("]");
        }
        finalPromptText.append(": ");
        out.println(finalPromptText.toString());
        Scanner scanner = new Scanner(in);
        this.getReturnValue().fromString(scanner.nextLine());
        return this.getReturnValue();
    }
}

