/*
 * Decompiled with CFR 0.152.
 */
package com.github.vatbub.commandlineUserPromptProcessor.parsables;

import com.github.vatbub.commandlineUserPromptProcessor.parsables.Parsable;
import com.github.vatbub.commandlineUserPromptProcessor.parsables.ParseException;
import org.jetbrains.annotations.Nullable;

public class ParsableBoolean
implements Parsable<Boolean> {
    private boolean value;
    private Boolean defaultValue = null;

    public ParsableBoolean() {
        this(null);
    }

    public ParsableBoolean(Boolean defaultValue) {
        this.setDefaultValue(defaultValue);
    }

    @Override
    public void fromString(String s) throws ParseException {
        switch (s) {
            case "true": 
            case "t": 
            case "y": 
            case "yes": {
                this.value = true;
                break;
            }
            case "false": 
            case "f": 
            case "n": 
            case "no": {
                this.value = false;
                break;
            }
            default: {
                if (this.defaultValue != null) {
                    this.value = this.defaultValue;
                    break;
                }
                throw new ParseException();
            }
        }
    }

    @Override
    public String getOptionsString() {
        return "true/false";
    }

    @Override
    @Nullable
    public String getStringForDefaultValue() {
        if (this.getDefaultValue() == null) {
            return null;
        }
        return this.getDefaultValue().toString();
    }

    @Override
    public Boolean getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(@Nullable Boolean defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public Boolean toValue() {
        return this.value;
    }
}

