/*
 * Decompiled with CFR 0.152.
 */
package com.github.vatbub.commandlineUserPromptProcessor.parsables;

import com.github.vatbub.commandlineUserPromptProcessor.parsables.Parsable;
import com.github.vatbub.commandlineUserPromptProcessor.parsables.ParseException;
import org.jetbrains.annotations.Nullable;

public class ParsableEnum<E extends Enum<E>>
implements Parsable<E> {
    private Class<E> eClass;
    private E value;
    private E defaultValue;

    public ParsableEnum(Class<E> eClass) {
        this(eClass, null);
    }

    public ParsableEnum(Class<E> eClass, E defaultValue) {
        this.seteClass(eClass);
        this.setDefaultValue(defaultValue);
    }

    @Override
    public void fromString(String s) throws ParseException {
        Enum[] enumConstants = (Enum[])this.geteClass().getEnumConstants();
        boolean found = false;
        for (Enum constant : enumConstants) {
            if (!constant.toString().equalsIgnoreCase(s)) continue;
            this.value = constant;
            found = true;
        }
        if (!found) {
            if (this.getDefaultValue() != null) {
                this.value = this.getDefaultValue();
            } else {
                throw new ParseException("No enum constant found: " + this.geteClass().getName() + "." + s);
            }
        }
    }

    @Override
    @Nullable
    public String getOptionsString() {
        Enum[] enumConstants = (Enum[])this.geteClass().getEnumConstants();
        CharSequence[] enumStrings = new String[enumConstants.length];
        for (int i = 0; i < enumConstants.length; ++i) {
            enumStrings[i] = enumConstants[i].toString();
        }
        return String.join((CharSequence)"/", enumStrings);
    }

    @Override
    @Nullable
    public String getStringForDefaultValue() {
        if (this.getDefaultValue() == null) {
            return null;
        }
        return ((Enum)this.getDefaultValue()).toString();
    }

    @Override
    public E getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(@Nullable E defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public E toValue() {
        return this.value;
    }

    public Class<E> geteClass() {
        return this.eClass;
    }

    public void seteClass(Class<E> eClass) {
        this.eClass = eClass;
    }
}

