/*
 * Decompiled with CFR 0.152.
 */
package com.github.vatbub.javaautostart;

import com.github.vatbub.javaautostart.AutoStartLaunchConfig;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0007J\u0006\u0010\r\u001a\u00020\nJ\b\u0010\u000e\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/github/vatbub/javaautostart/AutoStartManager;", "", "appName", "", "(Ljava/lang/String;)V", "isInAutoStart", "", "()Z", "keyParentPath", "addToAutoStart", "", "autoStartLaunchConfig", "Lcom/github/vatbub/javaautostart/AutoStartLaunchConfig;", "removeFromAutoStart", "verifyOs", "javaAutoStart"})
public final class AutoStartManager {
    @NotNull
    private final String appName;
    @NotNull
    private final String keyParentPath;

    public AutoStartManager(@NotNull String appName) {
        Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
        this.appName = appName;
        this.keyParentPath = "Software\\Microsoft\\Windows\\CurrentVersion\\Run";
    }

    public final boolean isInAutoStart() {
        this.verifyOs();
        return Advapi32Util.registryValueExists((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)this.keyParentPath, (String)this.appName);
    }

    @JvmOverloads
    public final void addToAutoStart(@NotNull AutoStartLaunchConfig autoStartLaunchConfig) {
        boolean createKeyResult;
        Intrinsics.checkNotNullParameter((Object)autoStartLaunchConfig, (String)"autoStartLaunchConfig");
        this.verifyOs();
        if (!Advapi32Util.registryKeyExists((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)this.keyParentPath) && !(createKeyResult = Advapi32Util.registryCreateKey((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)this.keyParentPath))) {
            throw new IllegalStateException("Unable to create the registry key for an unknown reason");
        }
        Advapi32Util.registrySetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)this.keyParentPath, (String)this.appName, (String)autoStartLaunchConfig.getAsCommand());
    }

    public static /* synthetic */ void addToAutoStart$default(AutoStartManager autoStartManager, AutoStartLaunchConfig autoStartLaunchConfig, int n, Object object) {
        if ((n & 1) != 0) {
            autoStartLaunchConfig = new AutoStartLaunchConfig(null, null, null, null, 15, null);
        }
        autoStartManager.addToAutoStart(autoStartLaunchConfig);
    }

    public final void removeFromAutoStart() {
        this.verifyOs();
        if (this.isInAutoStart()) {
            Advapi32Util.registryDeleteValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)this.keyParentPath, (String)this.appName);
        }
    }

    private final void verifyOs() {
        if (!SystemUtils.IS_OS_WINDOWS) {
            throw new IllegalStateException("Only Windows is supported");
        }
    }

    @JvmOverloads
    public final void addToAutoStart() {
        AutoStartManager.addToAutoStart$default(this, null, 1, null);
    }
}

