/*
 * Decompiled with CFR 0.152.
 */
package com.github.vatbub.safeAPIKeyStore;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryonet.Client;
import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.Listener;
import com.github.vatbub.safeAPIKeyStore.SafeAPIKeyStoreTestBase;
import com.github.vatbub.safeAPIKeyStore.common.APIKeyRequest;
import com.github.vatbub.safeAPIKeyStore.common.APIKeyResponse;
import com.github.vatbub.safeAPIKeyStore.common.BadRequestExceptionInternalImpl;
import com.github.vatbub.safeAPIKeyStore.common.InternalServerExceptionInternalImpl;
import com.github.vatbub.safeAPIKeyStore.common.KryoCommon;
import com.github.vatbub.safeAPIKeyStore.common.MultipleRequestsWithSameRSAKeyExceptionInternalImpl;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.crypto.Cipher;
import org.awaitility.Awaitility;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ServerTest
extends SafeAPIKeyStoreTestBase {
    private static Client client;
    private List<Listener> listeners = new LinkedList<Listener>();
    private List<Throwable> exceptionsThrownFromOtherThreads = new LinkedList<Throwable>();
    private Thread shutDownThread;
    private boolean shutClientDown = false;

    @After
    public void tearDownClient() {
        client.stop();
    }

    @Before
    public void setUpClient() throws IOException, InterruptedException {
        client = new Client();
        KryoCommon.registerClasses((Kryo)client.getKryo());
        client.getKryo().setReferences(true);
        client.start();
        client.connect(100000, "localhost", 1650);
        this.shutDownThread = new Thread(() -> {
            boolean isShutDown = false;
            while (!isShutDown) {
                System.out.print("");
                if (!this.shutClientDown) continue;
                client.close();
                Awaitility.await().atMost(5L, TimeUnit.SECONDS);
                isShutDown = true;
            }
        });
        this.shutDownThread.setName("shutDownThread");
        this.shutDownThread.start();
    }

    @Before
    public void resetClientListeners() {
        while (this.listeners.size() > 0) {
            client.removeListener(this.listeners.remove(0));
        }
    }

    @After
    public void failIfExceptionThrown() {
        boolean fail;
        boolean bl = fail = this.exceptionsThrownFromOtherThreads.size() > 0;
        while (this.exceptionsThrownFromOtherThreads.size() > 0) {
            this.exceptionsThrownFromOtherThreads.remove(0).printStackTrace();
        }
        if (fail) {
            Assert.fail((String)"Exceptions were reported from other threads");
        }
    }

    public void createListener(Listener listener) {
        this.listeners.add(listener);
        client.addListener(listener);
    }

    @Test
    public void regularRequestTest() throws NoSuchAlgorithmException, InterruptedException {
        final KeyPair keyPair = this.generateKeyPair();
        this.createListener(new Listener(){

            public void received(Connection connection, Object object) {
                try {
                    Charset encoding = Charset.forName("UTF-8");
                    Assert.assertTrue((boolean)(object instanceof APIKeyResponse));
                    APIKeyResponse response = (APIKeyResponse)object;
                    Assert.assertEquals((Object)"apiKey1", (Object)response.getRequestedApiKeyName());
                    Assert.assertEquals((Object)encoding.name(), (Object)response.getEncoding());
                    Cipher cipher = Cipher.getInstance("RSA");
                    cipher.init(2, keyPair.getPrivate());
                    Assert.assertEquals((Object)"12345", (Object)new String(cipher.doFinal(response.getEncryptedAPIKey()), response.getEncoding()));
                    ServerTest.this.endTest();
                }
                catch (Throwable e) {
                    ServerTest.this.exceptionsThrownFromOtherThreads.add(e);
                    ServerTest.this.endTest();
                }
            }
        });
        APIKeyRequest request = new APIKeyRequest(keyPair.getPublic().getEncoded(), "apiKey1");
        client.sendTCP((Object)request);
        this.shutDownThread.join();
    }

    private KeyPair generateKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        return keyPairGenerator.generateKeyPair();
    }

    @Test
    public void multipleRequestsWithSamePublicKeyTest() throws NoSuchAlgorithmException, InterruptedException {
        KeyPair keyPair = this.generateKeyPair();
        final APIKeyRequest request = new APIKeyRequest(keyPair.getPublic().getEncoded(), "apiKey1");
        this.createListener(new Listener(){
            private int callCounter = 0;

            public void received(Connection connection, Object object) {
                try {
                    if (this.callCounter == 0) {
                        Assert.assertTrue((boolean)(object instanceof APIKeyResponse));
                        client.sendTCP((Object)request);
                    } else {
                        Assert.assertTrue((boolean)(object instanceof MultipleRequestsWithSameRSAKeyExceptionInternalImpl));
                        ServerTest.this.endTest();
                    }
                    ++this.callCounter;
                }
                catch (Throwable e) {
                    ServerTest.this.exceptionsThrownFromOtherThreads.add(e);
                    ServerTest.this.endTest();
                }
            }
        });
        client.sendTCP((Object)request);
        this.shutDownThread.join();
    }

    @Test
    public void badRequestTest() throws NoSuchAlgorithmException, InterruptedException {
        this.createListener(new Listener(){

            public void received(Connection connection, Object object) {
                try {
                    Assert.assertTrue((boolean)(object instanceof BadRequestExceptionInternalImpl));
                    ServerTest.this.endTest();
                }
                catch (Throwable e) {
                    ServerTest.this.exceptionsThrownFromOtherThreads.add(e);
                    ServerTest.this.endTest();
                }
            }
        });
        Charset encoding = Charset.forName("UTF-8");
        client.sendTCP((Object)new APIKeyResponse("blablub", "bbb".getBytes(encoding), encoding.name()));
        this.shutDownThread.join();
    }

    @Test
    public void internalServerErrorTest() throws NoSuchAlgorithmException, InterruptedException {
        this.createListener(new Listener(){

            public void received(Connection connection, Object object) {
                try {
                    Assert.assertTrue((boolean)(object instanceof InternalServerExceptionInternalImpl));
                    ServerTest.this.endTest();
                }
                catch (Throwable e) {
                    ServerTest.this.exceptionsThrownFromOtherThreads.add(e);
                    ServerTest.this.endTest();
                }
            }
        });
        byte[] publicKey = new byte[]{0, 1};
        client.sendTCP((Object)new APIKeyRequest(publicKey, "apiKey1"));
        this.shutDownThread.join();
    }

    @Test
    public void apiKeysListTest() {
        Assert.assertEquals((Object)ServerTest.getApiKeysForTesting(), (Object)ServerTest.getServer().getApiKeys());
    }

    private void endTest() {
        this.shutClientDown = true;
    }
}

